/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets;

import java.util.List;
import java.util.function.Consumer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.DataFormatter;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.ui.eclipse.charts.api.ChartType;
import org.netxms.ui.eclipse.charts.api.DataSeries;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.tools.ColorConverter;

public class ChartLegend
extends Composite {
    private static final int SYMBOL_WIDTH = 12;
    private static final int EXTENDED_LEGEND_DATA_SPACING = 6;
    private final Color defaultForeground = Display.getCurrent().getSystemColor(2);
    private Chart chart;
    private Label[] headerLabels = new Label[4];
    private Label[][] dataLabels = new Label[16][4];
    private Font headerFont = null;
    private boolean vertical;
    private MouseListener mouseListener;

    public ChartLegend(final Chart chart, Color foreground, boolean vertical) {
        super((Composite)chart, 0);
        this.chart = chart;
        this.vertical = vertical;
        super.setBackground(chart.getBackground());
        super.setForeground(foreground);
        this.updateHeaderFont();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ChartLegend.this.headerFont != null) {
                    ChartLegend.this.headerFont.dispose();
                }
            }
        });
        this.mouseListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                chart.fireDoubleClickListeners();
            }
        };
        this.rebuild();
    }

    public void setForeground(Color color) {
        Color effectiveColor = color != null ? color : this.defaultForeground;
        super.setForeground(effectiveColor);
        this.updateChildren(this, c -> c.setForeground(effectiveColor));
    }

    public void setBackground(Color color) {
        Color effectiveColor = color != null ? color : this.chart.getBackground();
        super.setBackground(effectiveColor);
        this.updateChildren(this, c -> c.setBackground(effectiveColor));
    }

    private void updateChildren(Composite parent, Consumer<Control> operation) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            operation.accept(c);
            if (c instanceof Composite) {
                this.updateChildren((Composite)c, operation);
            }
            ++n2;
        }
    }

    private void updateHeaderFont() {
        if (this.headerFont != null) {
            this.headerFont.dispose();
        }
        FontData fd = this.getFont().getFontData()[0];
        fd.setStyle(1);
        this.headerFont = new Font((Device)this.getDisplay(), fd);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.updateHeaderFont();
        int i = 0;
        while (i < this.headerLabels.length) {
            if (this.headerLabels[i] != null) {
                this.headerLabels[i].setFont(this.headerFont);
            }
            ++i;
        }
        this.chart.layout();
    }

    public void rebuild() {
        int j;
        int color;
        int i;
        List<GraphItem> metrics;
        GridData gd;
        GridLayout layout;
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        ChartConfiguration configuration = this.chart.getConfiguration();
        if (configuration == null) {
            return;
        }
        if (configuration.isExtendedLegend() && this.chart.getType() == ChartType.LINE) {
            layout = new GridLayout();
            layout.numColumns = 5;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 1;
            this.setLayout((Layout)layout);
            new Label((Composite)this, 0);
            this.headerLabels[0] = new Label((Composite)this, 0);
            this.headerLabels[0].setText("Curr");
            this.headerLabels[0].setFont(this.headerFont);
            this.headerLabels[0].setBackground(this.getBackground());
            this.headerLabels[0].setForeground(this.getForeground());
            gd = new GridData();
            gd.horizontalIndent = 6;
            this.headerLabels[0].setLayoutData((Object)gd);
            this.headerLabels[1] = new Label((Composite)this, 0);
            this.headerLabels[1].setText("Min");
            this.headerLabels[1].setFont(this.headerFont);
            this.headerLabels[1].setBackground(this.getBackground());
            this.headerLabels[1].setForeground(this.getForeground());
            this.headerLabels[2] = new Label((Composite)this, 0);
            this.headerLabels[2].setText("Max");
            this.headerLabels[2].setFont(this.headerFont);
            this.headerLabels[2].setBackground(this.getBackground());
            this.headerLabels[2].setForeground(this.getForeground());
            this.headerLabels[3] = new Label((Composite)this, 0);
            this.headerLabels[3].setText("Avg");
            this.headerLabels[3].setFont(this.headerFont);
            this.headerLabels[3].setBackground(this.getBackground());
            this.headerLabels[3].setForeground(this.getForeground());
            metrics = this.chart.getItems();
            i = 0;
            while (i < metrics.size()) {
                color = metrics.get(i).getColor();
                new LegendLabel(this, color != -1 ? ColorConverter.rgbFromInt((int)color) : this.chart.getPaletteEntry(i).getRGBObject(), metrics.get(i).getDescription());
                j = 0;
                while (j < 4) {
                    this.dataLabels[i][j] = new Label((Composite)this, 0);
                    this.dataLabels[i][j].setBackground(this.getBackground());
                    this.dataLabels[i][j].setForeground(this.getForeground());
                    if (j == 0) {
                        gd = new GridData();
                        gd.horizontalIndent = 6;
                        this.dataLabels[i][j].setLayoutData((Object)gd);
                    }
                    ++j;
                }
                ++i;
            }
            this.refresh();
        } else if (configuration.isExtendedLegend() && (this.chart.getType() == ChartType.BAR || this.chart.getType() == ChartType.PIE)) {
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 1;
            this.setLayout((Layout)layout);
            new Label((Composite)this, 0);
            this.headerLabels[0] = new Label((Composite)this, 0);
            this.headerLabels[0].setText("Value");
            this.headerLabels[0].setFont(this.headerFont);
            this.headerLabels[0].setBackground(this.getBackground());
            this.headerLabels[0].setForeground(this.getForeground());
            gd = new GridData();
            gd.horizontalIndent = 6;
            this.headerLabels[0].setLayoutData((Object)gd);
            this.headerLabels[1] = new Label((Composite)this, 0);
            this.headerLabels[1].setText("Pct");
            this.headerLabels[1].setFont(this.headerFont);
            this.headerLabels[1].setBackground(this.getBackground());
            this.headerLabels[1].setForeground(this.getForeground());
            metrics = this.chart.getItems();
            i = 0;
            while (i < metrics.size()) {
                color = metrics.get(i).getColor();
                new LegendLabel(this, color != -1 ? ColorConverter.rgbFromInt((int)color) : this.chart.getPaletteEntry(i).getRGBObject(), metrics.get(i).getDescription());
                j = 0;
                while (j < 2) {
                    this.dataLabels[i][j] = new Label((Composite)this, 0);
                    this.dataLabels[i][j].setBackground(this.getBackground());
                    this.dataLabels[i][j].setForeground(this.getForeground());
                    if (j == 0) {
                        gd = new GridData();
                        gd.horizontalIndent = 6;
                        this.dataLabels[i][j].setLayoutData((Object)gd);
                    }
                    ++j;
                }
                ++i;
            }
            this.refresh();
        } else {
            layout = new RowLayout(this.vertical ? 512 : 256);
            layout.pack = false;
            layout.marginBottom = 0;
            layout.marginTop = 0;
            layout.marginLeft = 0;
            layout.marginRight = 0;
            this.setLayout((Layout)layout);
            List<GraphItem> metrics2 = this.chart.getItems();
            int i2 = 0;
            while (i2 < metrics2.size()) {
                int color2 = metrics2.get(i2).getColor();
                new LegendLabel(this, color2 != -1 ? ColorConverter.rgbFromInt((int)color2) : this.chart.getPaletteEntry(i2).getRGBObject(), metrics2.get(i2).getDescription());
                ++i2;
            }
        }
        Control[] controlArray2 = this.getChildren();
        int n3 = controlArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            Control c = controlArray2[n4];
            c.addMouseListener(this.mouseListener);
            ++n4;
        }
    }

    public void refresh() {
        boolean useMultipliers = this.chart.getConfiguration().isUseMultipliers();
        double total = 0.0;
        if (this.chart.getType() == ChartType.BAR || this.chart.getType() == ChartType.PIE) {
            for (DataSeries s : this.chart.getDataSeries()) {
                total += s.getCurrentValue();
            }
        }
        int row = 0;
        for (DataSeries s : this.chart.getDataSeries()) {
            GraphItem item = this.chart.getItem(row);
            String format = item.getDisplayFormat() == null || item.getDisplayFormat().isEmpty() ? (useMultipliers ? "%{m,u}.3f" : "%{u}.3f") : item.getDisplayFormat();
            DataFormatter formatter = new DataFormatter(format, DataType.FLOAT, item.getMeasurementUnit());
            this.dataLabels[row][0].setText(formatter.format(s.getCurrentValueAsString(), RegionalSettings.TIME_FORMATTER));
            if (this.chart.getType() == ChartType.LINE) {
                this.dataLabels[row][1].setText(formatter.format(Double.toString(s.getMinValue()), RegionalSettings.TIME_FORMATTER));
                this.dataLabels[row][2].setText(formatter.format(Double.toString(s.getMaxValue()), RegionalSettings.TIME_FORMATTER));
                this.dataLabels[row][3].setText(formatter.format(Double.toString(s.getAverageValue()), RegionalSettings.TIME_FORMATTER));
            } else {
                this.dataLabels[row][1].setText(String.format("%.2f%%", total > 0.0 ? s.getCurrentValue() / total * 100.0 : 0.0));
            }
            ++row;
        }
        this.chart.layout();
    }

    private class LegendLabel
    extends Composite {
        private Color color;

        LegendLabel(Composite parent, RGB color, String text) {
            super(parent, 0);
            this.color = ChartLegend.this.chart.getColorCache().create(color);
            this.setBackground(parent.getBackground());
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.horizontalSpacing = 4;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.setLayout((Layout)layout);
            Canvas symbol = new Canvas(this, 0){

                public Point computeSize(int wHint, int hHint, boolean changed) {
                    return new Point(12, 12);
                }
            };
            symbol.setBackground(this.getBackground());
            symbol.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.setBackground(LegendLabel.this.color);
                    e.gc.fillRectangle(LegendLabel.this.getClientArea());
                }
            });
            symbol.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            Label label = new Label((Composite)this, 0);
            label.setText(text);
            label.setBackground(this.getBackground());
            label.setForeground(parent.getForeground());
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
    }
}

