/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.Cookie;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.application.EntryPoint;
import org.eclipse.rap.rwt.client.service.ExitConfirmation;
import org.eclipse.rap.rwt.client.service.StartupParameters;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.netxms.base.VersionInfo;
import org.netxms.certificate.manager.CertificateManagerProvider;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.AuthenticationType;
import org.netxms.client.objects.Dashboard;
import org.netxms.nxmc.AppPropertiesLoader;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.Startup;
import org.netxms.nxmc.base.dialogs.PasswordExpiredDialog;
import org.netxms.nxmc.base.login.LoginDialog;
import org.netxms.nxmc.base.login.LoginJob;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.windows.MainWindow;
import org.netxms.nxmc.base.windows.PopOutViewWindow;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.alarms.AlarmNotifier;
import org.netxms.nxmc.modules.dashboards.views.AdHocDashboardView;
import org.netxms.nxmc.modules.datacollection.SummaryTablesCache;
import org.netxms.nxmc.modules.datacollection.api.GraphTemplateCache;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.DataCollectionDisplayInfo;
import org.netxms.nxmc.modules.logviewer.LogDescriptorRegistry;
import org.netxms.nxmc.modules.objects.ObjectIcons;
import org.netxms.nxmc.modules.objecttools.ObjectToolsCache;
import org.netxms.nxmc.modules.snmp.shared.MibCache;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class Startup
implements EntryPoint,
StartupParameters {
    public static final String LOGIN_COOKIE_NAME = "nxmcSessionLogin";
    private static final Logger logger = LoggerFactory.getLogger(Startup.class);
    private I18n i18n = LocalizationHelper.getI18n(Startup.class);
    private Display display;

    public int createUI() {
        PopOutViewWindow window;
        this.display = new Display();
        this.display.setData("org.eclipse.rap.rwt.cancelKeys", (Object)new String[]{"CTRL+F", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10"});
        this.display.setData("org.eclipse.rap.rwt.activeKeys", (Object)new String[]{"CTRL+F", "CTRL+F2", "F5", "F7", "F8", "F10"});
        File tempDir = (File)RWT.getUISession().getHttpSession().getServletContext().getAttribute("javax.servlet.context.tempdir");
        File stateDir = new File(tempDir + File.separator + "state");
        if (!stateDir.isDirectory()) {
            stateDir.mkdir();
        }
        Registry.setStateDir((File)stateDir);
        logger.info("NetXMS Management Console version " + VersionInfo.version() + " starting");
        logger.info("State directory: " + stateDir.getAbsolutePath());
        StringBuilder sb = new StringBuilder();
        for (String themeId : ((ApplicationContextImpl)RWT.getApplicationContext()).getThemeManager().getRegisteredThemeIds()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(themeId);
        }
        logger.info("Registered themes: " + sb.toString());
        PreferenceStore.open((String)stateDir.getAbsolutePath());
        DateFormatFactory.createInstance();
        SharedIcons.init();
        StatusDisplayInfo.init((Display)this.display);
        ObjectIcons.init((Display)this.display);
        DataCollectionDisplayInfo.init();
        String popoutId = this.getParameter("pop-out-id");
        if (popoutId != null) {
            window = PopOutViewWindow.create((String)popoutId);
            if (window == null) {
                logger.info("Application instance exit (invalid pop-out request ID)");
                this.display.dispose();
                return 0;
            }
        } else {
            if (!this.doLogin()) {
                logger.info("Application instance exit (cannot login)");
                this.display.dispose();
                return 0;
            }
            this.display.addListener(12, (Listener)new /* Unavailable Anonymous Inner Class!! */);
            MainWindow w = new MainWindow();
            Registry.setMainWindow((MainWindow)w);
            w.setBlockOnOpen(true);
            String dashboardName = this.getParameter("dashboard");
            logger.debug("Dashboard=" + dashboardName);
            if (dashboardName != null) {
                Dashboard dashboard = (Dashboard)Registry.getSession().findObjectByName(dashboardName, o -> o instanceof Dashboard);
                if (dashboard != null) {
                    AdHocDashboardView view = new AdHocDashboardView(0L, dashboard, null);
                    w.setPostOpenRunnable(() -> Display.getCurrent().asyncExec(() -> PopOutViewWindow.open((View)view)));
                } else {
                    logger.warn("Cannot find dashboard object with name \"" + dashboardName + "\"");
                }
            }
            window = w;
        }
        NXCSession session = Registry.getSession();
        MibCache.init((NXCSession)session, (Display)this.display);
        ObjectToolsCache.init();
        ObjectToolsCache.attachSession((Display)this.display, (NXCSession)session);
        SummaryTablesCache.attachSession((Display)this.display, (NXCSession)session);
        GraphTemplateCache.attachSession((Display)this.display, (NXCSession)session);
        LogDescriptorRegistry.attachSession((Display)this.display, (NXCSession)session);
        ExitConfirmation exitConfirmation = (ExitConfirmation)RWT.getClient().getService(ExitConfirmation.class);
        exitConfirmation.setMessage(this.i18n.tr("This will terminate your current session. Are you sure?"));
        window.open();
        logger.info("Application instance exit");
        AlarmNotifier.stop();
        this.display.dispose();
        return 0;
    }

    private boolean doLogin() {
        String[] parts;
        String storedCredentials;
        PreferenceStore settings = PreferenceStore.getInstance();
        boolean success = false;
        boolean autoConnect = false;
        boolean ignoreProtocolVersion = false;
        String password = "";
        String s = this.getParameter("login");
        if (s != null) {
            settings.set("Connect.Login", s);
        }
        if ((s = this.getParameter("password")) != null) {
            password = s;
            settings.set("Connect.AuthMethod", AuthenticationType.PASSWORD.getValue());
        }
        AppPropertiesLoader appProperties = new AppPropertiesLoader();
        s = this.getParameter("auto");
        if (s != null) {
            autoConnect = true;
        } else if (appProperties.getPropertyAsBoolean("autoLoginOnReload", true) && (storedCredentials = Startup.getCredentialsFromCookie()) != null && (parts = storedCredentials.split("`", 2)).length == 2) {
            logger.debug("Using stored credentials");
            settings.set("Connect.Login", parts[0]);
            password = parts[1];
            autoConnect = true;
        }
        settings.set("Connect.Server", appProperties.getProperty("server", "127.0.0.1"));
        LoginDialog loginDialog = new LoginDialog(null, appProperties);
        while (!success) {
            if (!autoConnect) {
                if (loginDialog.open() != 0) {
                    logger.info("Login cancelled by user - exiting");
                    return false;
                }
                password = loginDialog.getPassword();
            } else {
                autoConnect = false;
            }
            LoginJob job = new LoginJob(this.display, ignoreProtocolVersion);
            job.setPassword(password);
            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(null);
            try {
                monitorDialog.run(true, false, (IRunnableWithProgress)job);
                success = true;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                logger.error("Login job failed", cause);
                if (cause instanceof NXCException && ((NXCException)cause).getErrorCode() == 164) continue;
                MessageDialog.openError(null, (String)this.i18n.tr("Connection Error"), (String)cause.getLocalizedMessage());
            }
            catch (Exception e) {
                logger.error("Unexpected exception while running login job", (Throwable)e);
                MessageDialog.openError(null, (String)this.i18n.tr("Internal error"), (String)e.toString());
            }
        }
        CertificateManagerProvider.dispose();
        NXCSession session = Registry.getSession();
        if (session.getAuthenticationMethod() == AuthenticationType.PASSWORD && session.isPasswordExpired()) {
            this.requestPasswordChange(loginDialog.getPassword(), session);
        }
        if (appProperties.getPropertyAsBoolean("autoLoginOnReload", true)) {
            try {
                Cookie cookie = new Cookie("nxmcSessionLogin", Base64.encodeBase64String((byte[])(settings.getAsString("Connect.Login") + "`" + password).getBytes("UTF-8")));
                cookie.setSecure(ContextProvider.getRequest().isSecure());
                cookie.setMaxAge(-1);
                cookie.setHttpOnly(true);
                ContextProvider.getResponse().addCookie(cookie);
            }
            catch (UnsupportedEncodingException e) {
                logger.debug("Error encoding credentials cookie", (Throwable)e);
            }
        }
        return true;
    }

    private static String getCredentialsFromCookie() {
        Cookie[] cookies = ContextProvider.getRequest().getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!"nxmcSessionLogin".equals(cookie.getName())) continue;
                logger.debug("Found credentials cookie: " + cookie.getValue());
                try {
                    return new String(Base64.decodeBase64((String)cookie.getValue()), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    return null;
                }
            }
        }
        return null;
    }

    private void requestPasswordChange(String currentPassword, NXCSession session) {
        PasswordExpiredDialog dlg = new PasswordExpiredDialog(null, session.getGraceLogins());
        while (dlg.open() == 0) {
            2 job = new /* Unavailable Anonymous Inner Class!! */;
            try {
                ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(null);
                monitorDialog.run(true, false, (IRunnableWithProgress)job);
                MessageDialogHelper.openInformation(null, (String)this.i18n.tr("Information"), (String)this.i18n.tr("Password changed successfully"));
                return;
            }
            catch (InvocationTargetException e) {
                MessageDialogHelper.openError(null, (String)this.i18n.tr("Error"), (String)String.format(this.i18n.tr("Cannot change password (%s)"), e.getCause().getLocalizedMessage()));
                continue;
            }
            catch (InterruptedException e) {
                logger.error("Unexpected exception while doing password change", (Throwable)e);
                MessageDialog.openError(null, (String)this.i18n.tr("Internal error"), (String)e.toString());
                continue;
            }
            break;
        }
        return;
    }

    public Collection<String> getParameterNames() {
        StartupParameters service = (StartupParameters)RWT.getClient().getService(StartupParameters.class);
        return service == null ? new ArrayList() : service.getParameterNames();
    }

    public String getParameter(String name) {
        StartupParameters service = (StartupParameters)RWT.getClient().getService(StartupParameters.class);
        return service == null ? null : service.getParameter(name);
    }

    public List<String> getParameterValues(String name) {
        StartupParameters service = (StartupParameters)RWT.getClient().getService(StartupParameters.class);
        return service == null ? null : service.getParameterValues(name);
    }
}

