/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.views;

import java.util.Stack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.views.NavigationView;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewContainer;
import org.netxms.nxmc.base.views.ViewWithContext;
import org.netxms.nxmc.base.views.helpers.NavigationHistory;
import org.netxms.nxmc.keyboard.KeyStroke;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class ViewStack
extends ViewContainer {
    private static final Logger logger = LoggerFactory.getLogger(ViewStack.class);
    private final I18n i18n = LocalizationHelper.getI18n(ViewStack.class);
    private Stack<View> views = new Stack();
    private boolean contextAware = true;
    private ToolBar viewList;
    private Composite viewArea;

    public ViewStack(Window window, Perspective perspective, Composite parent, boolean enableViewExtraction, boolean enableViewPinning, boolean enableNavigationHistory) {
        super(window, perspective, parent, 2048);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        this.setLayout((Layout)layout);
        this.viewList = new ToolBar((Composite)this, 0x804040);
        this.viewList.setFont(JFaceResources.getBannerFont());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.viewList.setLayoutData((Object)gd);
        this.viewToolBarManager = new ToolBarManager(8519744);
        this.viewToolBar = this.viewToolBarManager.createControl((Composite)this);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = false;
        this.viewToolBar.setLayoutData((Object)gd);
        this.viewControlBar = new ToolBar((Composite)this, 8519744);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = false;
        this.viewControlBar.setLayoutData((Object)gd);
        if (enableNavigationHistory) {
            this.navigationBack = new ToolItem(this.viewControlBar, 8);
            this.navigationBack.setImage(SharedIcons.IMG_NAV_BACKWARD);
            this.navigationBack.setToolTipText(this.i18n.tr("Back (Alt+Left)"));
            this.navigationBack.setEnabled(false);
            this.navigationBack.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.keyBindingManager.addBinding(65536, 0x1000003, (IAction)new /* Unavailable Anonymous Inner Class!! */);
            this.navigationForward = new ToolItem(this.viewControlBar, 8);
            this.navigationForward.setImage(SharedIcons.IMG_NAV_FORWARD);
            this.navigationForward.setToolTipText(this.i18n.tr("Forward (Alt+Right)"));
            this.navigationForward.setEnabled(false);
            this.navigationForward.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.keyBindingManager.addBinding(65536, 0x1000004, (IAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.refreshView = new ToolItem(this.viewControlBar, 8);
        this.refreshView.setImage(SharedIcons.IMG_REFRESH);
        this.refreshView.setToolTipText(this.i18n.tr("Refresh (F5)"));
        this.refreshView.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.keyBindingManager.addBinding(0, 0x100000E, (IAction)new /* Unavailable Anonymous Inner Class!! */);
        if (enableViewPinning) {
            ToolItem pinView = new ToolItem(this.viewControlBar, 8);
            pinView.setImage(SharedIcons.IMG_PIN);
            pinView.setToolTipText(this.i18n.tr("Add view to pinboard (F7)"));
            pinView.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.keyBindingManager.addBinding(0, 0x1000010, (IAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (enableViewExtraction) {
            ToolItem popOutView = new ToolItem(this.viewControlBar, 8);
            popOutView.setImage(SharedIcons.IMG_POP_OUT);
            popOutView.setToolTipText(this.i18n.tr("Pop out view (F8)"));
            popOutView.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.keyBindingManager.addBinding(0, 0x1000011, (IAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.keyBindingManager.addBinding("M1+W", (IAction)new /* Unavailable Anonymous Inner Class!! */);
        Label separator = new Label((Composite)this, 258);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gd);
        this.viewArea = new Composite((Composite)this, 0);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.viewArea.setLayoutData((Object)gd);
        this.viewArea.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setView(View view) {
        for (View v : this.views) {
            logger.debug("Existing view " + v.getGlobalId() + " replaced by view " + (view != null ? view.getGlobalId() : "(null)"));
            v.dispose();
        }
        this.views.clear();
        if (view != null) {
            this.pushViewInternal(view, false);
        } else {
            this.navigationHistory = null;
            if (this.navigationForward != null) {
                this.navigationForward.setEnabled(false);
            }
            if (this.navigationBack != null) {
                this.navigationBack.setEnabled(false);
            }
        }
        this.updateViewList();
    }

    public void pushView(View view) {
        this.pushView(view, false);
    }

    public void pushView(View view, boolean activate) {
        if (view == null) {
            return;
        }
        this.pushViewInternal(view, activate);
        this.addViewListElement(view);
    }

    private void pushViewInternal(View view, boolean activate) {
        this.views.push(view);
        view.create((ViewContainer)this, this.viewArea, this.onFilterCloseCallback);
        if (this.contextAware && view instanceof ViewWithContext) {
            ((ViewWithContext)view).setContext(this.context);
        }
        this.activateView(view);
        this.updateRefreshActionState();
        if (activate) {
            view.setFocus();
        }
    }

    public boolean popView() {
        if (this.views.empty()) {
            return true;
        }
        View view = (View)this.views.pop();
        if (view instanceof ConfigurationView && ((ConfigurationView)view).isModified()) {
            int choice = MessageDialogHelper.openQuestionWithCancel((Shell)view.getWindow().getShell(), (String)this.i18n.tr("Unsaved Changes"), (String)((ConfigurationView)view).getSaveOnExitPrompt());
            if (choice == 2) {
                this.views.push(view);
                return false;
            }
            if (choice == 0) {
                ((ConfigurationView)view).save();
            }
        }
        view.dispose();
        int count = this.viewList.getItemCount();
        this.viewList.getItem(--count).dispose();
        if (count > 0) {
            this.viewList.getItem(--count).dispose();
        }
        this.updateRefreshActionState();
        view = this.getActiveView();
        if (view == null) {
            return true;
        }
        this.activateView(view);
        return true;
    }

    private void activateView(View view) {
        this.updateViewToolBar(view);
        boolean controlBarChanged = this.updateViewMenu(view);
        if (view.hasFilter()) {
            if (this.enableFilter == null) {
                this.enableFilter = new ToolItem(this.viewControlBar, 32, this.navigationBack != null ? 2 : 0);
                this.enableFilter.setImage(SharedIcons.IMG_FILTER);
                this.enableFilter.setToolTipText(String.format(this.i18n.tr("Show filter (%s)"), KeyStroke.normalizeDefinition((String)"M1+F2")));
                this.enableFilter.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
                controlBarChanged = true;
            }
            this.enableFilter.setSelection(view.isFilterEnabled());
            this.showFilterAction.setEnabled(true);
        } else {
            if (this.enableFilter != null) {
                this.enableFilter.dispose();
                this.enableFilter = null;
                controlBarChanged = true;
            }
            this.showFilterAction.setEnabled(false);
        }
        if (controlBarChanged) {
            this.layout(true, true);
        }
        NavigationHistory navigationHistory = this.navigationHistory = view instanceof NavigationView ? ((NavigationView)view).getNavigationHistory() : null;
        if (this.navigationForward != null) {
            this.navigationForward.setEnabled(this.navigationHistory != null && this.navigationHistory.canGoForward());
        }
        if (this.navigationBack != null) {
            this.navigationBack.setEnabled(this.navigationHistory != null && this.navigationHistory.canGoBackward());
        }
        view.getViewArea().setSize(this.viewArea.getSize());
        view.activate();
    }

    public void switchToView(View view, boolean focus) {
        if (!this.views.contains(view)) {
            return;
        }
        while (this.getActiveView() != view && this.popView()) {
        }
        if (this.getActiveView() == view) {
            view.setFocus();
        }
    }

    protected View getActiveView() {
        return this.views.empty() ? null : (View)this.views.peek();
    }

    public boolean isViewActive(View view) {
        return !this.views.empty() && this.views.peek() == view;
    }

    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        if (context == this.context) {
            return;
        }
        this.context = context;
        View view = this.getActiveView();
        if (this.contextAware && view != null && view instanceof ViewWithContext) {
            ((ViewWithContext)view).setContext(context);
        }
    }

    public void updateContext(Object context) {
        this.context = context;
    }

    public boolean isContextAware() {
        return this.contextAware;
    }

    public void setContextAware(boolean contextAware) {
        this.contextAware = contextAware;
    }

    public boolean setFocus() {
        View view = this.getActiveView();
        if (view != null && !view.isClientAreaDisposed()) {
            view.setFocus();
        } else {
            this.viewArea.setFocus();
        }
        return true;
    }

    private void updateViewList() {
        for (ToolItem i : this.viewList.getItems()) {
            i.dispose();
        }
        for (View v : this.views) {
            this.addViewListElement(v);
        }
    }

    private void addViewListElement(View view) {
        ToolItem i;
        if (this.viewList.getItemCount() > 0) {
            i = new ToolItem(this.viewList, 8);
            i.setText(">");
            i.setEnabled(false);
        }
        i = new ToolItem(this.viewList, 8);
        i.setText(view.getFullName());
        i.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }
}

