/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.alarms.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.events.Alarm;
import org.netxms.client.events.AlarmHandle;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.helpers.TransformationSelectionProvider;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.base.widgets.CompositeWithMessageArea;
import org.netxms.nxmc.base.widgets.SortableTreeViewer;
import org.netxms.nxmc.base.widgets.helpers.MenuContributionItem;
import org.netxms.nxmc.base.widgets.helpers.SearchQueryAttribute;
import org.netxms.nxmc.base.widgets.helpers.SearchQueryAttributeValueProvider;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.alarms.AlarmNotifier;
import org.netxms.nxmc.modules.alarms.widgets.AlarmList;
import org.netxms.nxmc.modules.alarms.widgets.helpers.AlarmComparator;
import org.netxms.nxmc.modules.alarms.widgets.helpers.AlarmListFilter;
import org.netxms.nxmc.modules.alarms.widgets.helpers.AlarmListLabelProvider;
import org.netxms.nxmc.modules.alarms.widgets.helpers.AlarmTreeContentProvider;
import org.netxms.nxmc.modules.objects.ObjectMenuFactory;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.tools.RefreshTimer;
import org.netxms.nxmc.tools.VisibilityValidator;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class AlarmList
extends CompositeWithMessageArea {
    public static final int COLUMN_SEVERITY = 0;
    public static final int COLUMN_STATE = 1;
    public static final int COLUMN_SOURCE = 2;
    public static final int COLUMN_ZONE = 3;
    public static final int COLUMN_MESSAGE = 4;
    public static final int COLUMN_COUNT = 5;
    public static final int COLUMN_COMMENTS = 6;
    public static final int COLUMN_HELPDESK_REF = 7;
    public static final int COLUMN_ACK_BY = 8;
    public static final int COLUMN_CREATED = 9;
    public static final int COLUMN_LASTCHANGE = 10;
    private I18n i18n = LocalizationHelper.getI18n(AlarmList.class);
    private View view;
    private NXCSession session = null;
    private SessionListener clientListener = null;
    private RefreshTimer refreshTimer;
    private SortableTreeViewer alarmViewer;
    private AlarmListLabelProvider labelProvider;
    private AlarmListFilter alarmFilter;
    private TransformationSelectionProvider alarmSelectionProvider;
    private Map<Long, Alarm> alarmList = new HashMap();
    private List<Alarm> newAlarmList = new ArrayList();
    private Set<Long> updateList = new HashSet();
    private Map<Long, AlarmHandle> displayList = new HashMap();
    private VisibilityValidator visibilityValidator;
    private boolean needInitialRefresh = false;
    private boolean filterRunning = false;
    private boolean filterRunPending = false;
    private Action actionCopy;
    private Action actionCopyMessage;
    private Action actionAcknowledge;
    private Action actionResolve;
    private Action actionStickyAcknowledge;
    private Action actionTerminate;
    private Action actionShowObjectDetails;
    private Action actionCreateIssue;
    private Action actionShowIssue;
    private Action actionUnlinkIssue;
    private Action actionExportToCsv;
    private Action actionShowAlarmDetails;
    private MenuManager timeAcknowledgeMenu;
    private List<Action> timeAcknowledge;
    private Action timeAcknowledgeOther;
    private Action actionShowColor;
    private boolean initShowfilter;
    private boolean isLocalNotificationsEnabled = false;
    private long rootObject;
    private boolean blinkEnabled = false;
    private final SearchQueryAttribute[] attributeProposals = new SearchQueryAttribute[]{new SearchQueryAttribute("AcknowledgedBy:"), new SearchQueryAttribute("Event:", (SearchQueryAttributeValueProvider)new EventAttributeValueProvider(this)), new SearchQueryAttribute("HasComments:", new String[]{"yes", "no"}), new SearchQueryAttribute("NOT"), new SearchQueryAttribute("RepeatCount:"), new SearchQueryAttribute("ResolvedBy:"), new SearchQueryAttribute("Severity:", new String[]{"NORMAL", "WARNING", "MINOR", "MAJOR", "CRITICAL"}), new SearchQueryAttribute("Source:", (SearchQueryAttributeValueProvider)new SourceAttributeValueProvider(this)), new SearchQueryAttribute("State:", new String[]{"Outstanding", "Acknowledged", "Resolved"}), new SearchQueryAttribute("Zone:", (SearchQueryAttributeValueProvider)new ZoneAttributeValueProvider())};

    public AlarmList(View view, Composite parent, int style, String configPrefix, VisibilityValidator visibilityValidator) {
        super(parent, style);
        this.session = Registry.getSession();
        this.view = view;
        this.visibilityValidator = visibilityValidator;
        this.getContent().setLayout((Layout)new FillLayout());
        String[] names = new String[]{this.i18n.tr("Severity"), this.i18n.tr("State"), this.i18n.tr("Source"), this.i18n.tr("Zone"), this.i18n.tr("Message"), this.i18n.tr("Count"), this.i18n.tr("Comments"), this.i18n.tr("Helpdesk ID"), this.i18n.tr("Ack/Resolve By"), this.i18n.tr("Created"), this.i18n.tr("Last Change")};
        int[] widths = new int[]{100, 100, 150, 130, 300, 70, 70, 120, 100, 100, 100};
        this.alarmViewer = new SortableTreeViewer(this.getContent(), names, widths, 0, 1024, -1);
        if (!this.session.isZoningEnabled()) {
            this.alarmViewer.removeColumnById(3);
        }
        WidgetHelper.restoreTreeViewerSettings((SortableTreeViewer)this.alarmViewer, (String)configPrefix);
        this.labelProvider = new AlarmListLabelProvider((TreeViewer)this.alarmViewer);
        this.labelProvider.setShowColor(PreferenceStore.getInstance().getAsBoolean("AlarmList.ShowStatusColor", false));
        this.alarmViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.alarmViewer.setContentProvider((IContentProvider)new AlarmTreeContentProvider());
        this.alarmViewer.setComparator((ViewerComparator)new AlarmComparator());
        this.alarmFilter = new AlarmListFilter();
        this.alarmViewer.addFilter((ViewerFilter)this.alarmFilter);
        this.alarmViewer.getTree().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.alarmViewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        PreferenceStore ps = PreferenceStore.getInstance();
        this.initShowfilter = ps.getAsBoolean("AlarmList.ShowFilter", true);
        this.createActions();
        this.createContextMenu();
        if (visibilityValidator == null || visibilityValidator.isVisible()) {
            this.refresh();
        } else {
            this.needInitialRefresh = true;
        }
        this.refreshTimer = new RefreshTimer(Math.max(this.session.getMinViewRefreshInterval(), 500), this.alarmViewer.getControl(), (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.refreshTimer.setMinimalDelay(100L);
        this.clientListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.clientListener);
        5 blinkTimer = new /* Unavailable Anonymous Inner Class!! */;
        if (ps.getAsBoolean("AlarmList.BlinkOutstandingAlarm", false)) {
            this.blinkEnabled = true;
            this.getDisplay().timerExec(500, (Runnable)blinkTimer);
        }
        6 propertyChangeListener = new /* Unavailable Anonymous Inner Class!! */;
        ps.addPropertyChangeListener((IPropertyChangeListener)propertyChangeListener);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.alarmSelectionProvider = new /* Unavailable Anonymous Inner Class!! */;
        this.alarmViewer.setInput((Object)this.displayList);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.alarmSelectionProvider;
    }

    private void createActions() {
        this.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopy.setId("AlarmList.Copy");
        this.actionCopyMessage = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyMessage.setId("AlarmList.CopyMessage");
        this.actionAcknowledge = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAcknowledge.setId("AlarmList.Acknowledge");
        this.actionStickyAcknowledge = new /* Unavailable Anonymous Inner Class!! */;
        this.actionStickyAcknowledge.setId("AlarmList.StickyAcknowledge");
        this.actionResolve = new /* Unavailable Anonymous Inner Class!! */;
        this.actionResolve.setId("AlarmList.Resolve");
        this.actionTerminate = new /* Unavailable Anonymous Inner Class!! */;
        this.actionTerminate.setId("AlarmList.Terminate");
        this.actionCreateIssue = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowIssue = new /* Unavailable Anonymous Inner Class!! */;
        this.actionUnlinkIssue = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowObjectDetails = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowObjectDetails.setId("AlarmList.ShowObjectDetails");
        this.actionExportToCsv = new ExportToCsvAction(this.view, (ColumnViewer)this.alarmViewer, true);
        this.timeAcknowledgeOther = new /* Unavailable Anonymous Inner Class!! */;
        this.timeAcknowledgeOther.setId("AlarmList.TimeAcknowledgeOther");
        this.actionShowColor = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowColor.setChecked(this.labelProvider.isShowColor());
        this.actionShowAlarmDetails = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowAlarmDetails.setId("AlarmList.ShowAlarmDetails");
    }

    private void initializeTimeAcknowledge() {
        PreferenceStore settings = PreferenceStore.getInstance();
        int menuSize = settings.getAsInteger("AlarmList.AckMenuSize", 0);
        if (menuSize < 1) {
            settings.set("AlarmList.AckMenuSize", 4);
            this.timeAcknowledge = new ArrayList(4);
            this.createDefaultIntervals();
            settings.set("AlarmList.AckMenuEntry.0", 3600);
            settings.set("AlarmList.AckMenuEntry.1", 14400);
            settings.set("AlarmList.AckMenuEntry.2", 86400);
            settings.set("AlarmList.AckMenuEntry.3", 172800);
            return;
        }
        this.timeAcknowledge = new ArrayList(menuSize);
        for (int i = 0; i < menuSize; ++i) {
            int time = settings.getAsInteger("AlarmList.AckMenuEntry." + Integer.toString(i), 0);
            if (time == 0) continue;
            this.timeAcknowledge.add(this.createTimeAcknowledgeAction(time, i));
        }
    }

    private void createDefaultIntervals() {
        this.timeAcknowledge.add(this.createTimeAcknowledgeAction(3600, 0));
        this.timeAcknowledge.add(this.createTimeAcknowledgeAction(14400, 1));
        this.timeAcknowledge.add(this.createTimeAcknowledgeAction(86400, 2));
        this.timeAcknowledge.add(this.createTimeAcknowledgeAction(172800, 2));
    }

    private Action createTimeAcknowledgeAction(int time, int index) {
        22 action = new /* Unavailable Anonymous Inner Class!! */;
        action.setId("AlarmList.TimeAcknowledge." + Integer.toString(index));
        return action;
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.alarmViewer.getControl());
        this.alarmViewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        long contextId;
        Menu toolsMenu;
        IStructuredSelection selection = this.alarmSelectionProvider.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        int states = this.getSelectionType(selection.toArray());
        if (states == 2) {
            manager.add((IAction)this.actionAcknowledge);
            manager.add((IAction)this.actionStickyAcknowledge);
            if (this.session.isTimedAlarmAckEnabled()) {
                this.initializeTimeAcknowledge();
                this.timeAcknowledgeMenu = new MenuManager(this.i18n.tr("Sticky acknowledge for"), "timeAcknowledge");
                for (Action act : this.timeAcknowledge) {
                    this.timeAcknowledgeMenu.add((IAction)act);
                }
                this.timeAcknowledgeMenu.add((IContributionItem)new Separator());
                this.timeAcknowledgeMenu.add((IAction)this.timeAcknowledgeOther);
                manager.add((IContributionItem)this.timeAcknowledgeMenu);
            }
        }
        if (states < 4) {
            manager.add((IAction)this.actionResolve);
        }
        if (states == 4 || !this.session.isStrictAlarmStatusFlow()) {
            manager.add((IAction)this.actionTerminate);
        }
        manager.add((IContributionItem)new Separator());
        if (selection.size() == 1) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionShowObjectDetails);
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionCopyMessage);
        manager.add((IAction)this.actionExportToCsv);
        if (selection.size() == 1) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionShowAlarmDetails);
            if (this.session.isHelpdeskLinkActive()) {
                manager.add((IContributionItem)new Separator());
                if (((Alarm)selection.getFirstElement()).getHelpdeskState() == 0) {
                    manager.add((IAction)this.actionCreateIssue);
                } else {
                    manager.add((IAction)this.actionShowIssue);
                    if ((this.session.getUserSystemRights() & 0x10000000L) != 0L) {
                        manager.add((IAction)this.actionUnlinkIssue);
                    }
                }
            }
        }
        if ((toolsMenu = ObjectMenuFactory.createToolsMenu((IStructuredSelection)selection, (long)(contextId = this.view instanceof ObjectView ? ((ObjectView)this.view).getObjectId() : 0L), (Menu)((MenuManager)manager).getMenu(), null, (ViewPlacement)new ViewPlacement(this.view))) != null) {
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)new MenuContributionItem(this.i18n.tr("&Tools"), toolsMenu));
        }
    }

    private int getSelectionType(Object[] array) {
        int type = 0;
        for (int i = 0; i < array.length; ++i) {
            type |= ((Alarm)array[i]).getState() + 2;
        }
        return type;
    }

    public void setRootObject(long objectId) {
        this.rootObject = objectId;
        this.alarmFilter.setRootObject(objectId);
        this.filterRunPending = true;
        this.doPendingUpdates();
    }

    public void setRootObjects(List<Long> selectedObjects) {
        this.alarmFilter.setRootObjects(selectedObjects);
        this.filterRunPending = true;
        this.doPendingUpdates();
    }

    public void doPendingUpdates() {
        if (this.visibilityValidator != null && !this.visibilityValidator.isVisible()) {
            return;
        }
        if (this.needInitialRefresh) {
            this.needInitialRefresh = false;
            this.refresh();
        } else if (this.filterRunPending) {
            this.startFilterAndLimit();
        }
    }

    private void startFilterAndLimit() {
        if (this.filterRunning || this.visibilityValidator != null && !this.visibilityValidator.isVisible()) {
            this.filterRunPending = true;
            return;
        }
        this.filterRunning = true;
        this.filterRunPending = false;
        24 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterAndLimit() {
        HashMap<Long, Alarm> filteredAlarms;
        HashMap<Long, Alarm> selectedAlarms = new HashMap<Long, Alarm>();
        for (Alarm alarm : this.alarmList.values()) {
            if (!this.alarmFilter.filter(alarm)) continue;
            selectedAlarms.put(alarm.getId(), alarm);
        }
        if (this.session.getAlarmListDisplayLimit() > 0 && selectedAlarms.size() > this.session.getAlarmListDisplayLimit()) {
            ArrayList l = new ArrayList(selectedAlarms.values());
            Collections.sort(l, new /* Unavailable Anonymous Inner Class!! */);
            filteredAlarms = new HashMap(this.session.getAlarmListDisplayLimit());
            for (Alarm a : l.subList(0, this.session.getAlarmListDisplayLimit())) {
                filteredAlarms.put(a.getId(), a);
            }
        } else {
            filteredAlarms = selectedAlarms;
        }
        ArrayList updatedAlarms = new ArrayList(this.updateList.size());
        updatedAlarms.addAll(this.updateList);
        this.updateList.clear();
        this.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        List list = this.newAlarmList;
        synchronized (list) {
            if (!AlarmNotifier.isGlobalSoundEnabled((Display)this.getDisplay()) && this.view != null && this.view.isVisible() && this.isLocalNotificationsEnabled) {
                for (Alarm a : this.newAlarmList) {
                    if (!filteredAlarms.containsKey(a.getId())) continue;
                    AlarmNotifier.playSounOnAlarm((Alarm)a);
                }
            }
            this.newAlarmList.clear();
        }
    }

    public void refresh() {
        if (this.visibilityValidator != null && !this.visibilityValidator.isVisible()) {
            return;
        }
        this.filterRunning = true;
        this.filterRunPending = false;
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void setStateFilter(int filter) {
        this.alarmFilter.setStateFilter(filter);
    }

    public void setSeverityFilter(int filter) {
        this.alarmFilter.setSeverityFilter(filter);
    }

    private void acknowledgeAlarms(boolean sticky, int time) {
        IStructuredSelection selection = this.alarmSelectionProvider.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] alarms = selection.toArray();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void resolveAlarms() {
        IStructuredSelection selection = this.alarmSelectionProvider.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        ArrayList<Long> alarmIds = new ArrayList<Long>(selection.size());
        for (Object o : selection.toList()) {
            alarmIds.add(((Alarm)o).getId());
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void terminateAlarms() {
        IStructuredSelection selection = this.alarmSelectionProvider.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        ArrayList<Long> alarmIds = new ArrayList<Long>(selection.size());
        for (Object o : selection.toList()) {
            alarmIds.add(((Alarm)o).getId());
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createIssue() {
        IStructuredSelection selection = this.alarmSelectionProvider.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        long id = ((Alarm)selection.getFirstElement()).getId();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void showIssue() {
        IStructuredSelection selection = this.alarmSelectionProvider.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        long id = ((Alarm)selection.getFirstElement()).getId();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void unlinkIssue() {
        IStructuredSelection selection = this.alarmSelectionProvider.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        long id = ((Alarm)selection.getFirstElement()).getId();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public TreeViewer getViewer() {
        return this.alarmViewer;
    }

    public IAction getActionShowColors() {
        return this.actionShowColor;
    }

    public void setShowColors(boolean show) {
        this.labelProvider.setShowColor(show);
        this.actionShowColor.setChecked(show);
        this.alarmViewer.refresh();
        PreferenceStore.getInstance().set("AlarmList.ShowStatusColor", show);
    }

    public boolean isFilterEnabled() {
        return this.initShowfilter;
    }

    public void setIsLocalSoundEnabled(boolean isLocalSoundEnabled) {
        this.isLocalNotificationsEnabled = isLocalSoundEnabled;
    }

    public AbstractViewerFilter getFilter() {
        return this.alarmFilter;
    }

    public SearchQueryAttribute[] getAttributeProposals() {
        return this.attributeProposals;
    }
}

