/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.config;

import java.util.ArrayList;
import java.util.List;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.ObjectDetailsConfig;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.core.Persister;

public class ObjectDetailsConfig
extends DashboardElementConfig {
    @Element(required=false)
    private String query = "";
    @ElementList(required=false)
    private List<ObjectProperty> properties;
    @Element(required=false)
    private int refreshRate = 60;
    @ElementList(required=false)
    private List<String> orderingProperties = null;
    @Element(required=false)
    private int recordLimit = 0;

    public static ObjectDetailsConfig createFromXml(String xml) throws Exception {
        Persister serializer = new Persister();
        return (ObjectDetailsConfig)serializer.read(ObjectDetailsConfig.class, xml);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public List<ObjectProperty> getProperties() {
        return this.properties == null ? new ArrayList() : this.properties;
    }

    public void setProperties(List<ObjectProperty> properties) {
        this.properties = properties;
    }

    public List<String> getOrderingProperties() {
        return this.orderingProperties == null ? new ArrayList() : this.orderingProperties;
    }

    public String getOrderingPropertiesAsText() {
        if (this.orderingProperties == null || this.orderingProperties.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder((String)this.orderingProperties.get(0));
        for (int i = 1; i < this.orderingProperties.size(); ++i) {
            sb.append(',');
            sb.append((String)this.orderingProperties.get(i));
        }
        return sb.toString();
    }

    public void setOrderingProperties(List<String> orderingProperties) {
        this.orderingProperties = orderingProperties;
    }

    public void setOrderingProperties(String orderingProperties) {
        if (orderingProperties == null || orderingProperties.isEmpty()) {
            this.orderingProperties = null;
        } else {
            String[] parts = orderingProperties.split(",");
            this.orderingProperties = new ArrayList(parts.length);
            for (String p : parts) {
                if ((p = p.trim()).isEmpty()) continue;
                this.orderingProperties.add(p);
            }
        }
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
    }

    public int getRecordLimit() {
        return this.recordLimit;
    }

    public void setRecordLimit(int recordLimit) {
        this.recordLimit = recordLimit;
    }
}

