/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import java.util.HashSet;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.ObjectToolsConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.modules.objects.ObjectContext;
import org.netxms.nxmc.modules.objecttools.ObjectToolExecutor;
import org.netxms.nxmc.modules.objecttools.ObjectToolsCache;
import org.netxms.nxmc.tools.ColorConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectTools
extends ElementWidget {
    private static final Logger logger = LoggerFactory.getLogger(ObjectTools.class);
    private ObjectToolsConfig config;

    public ObjectTools(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        try {
            this.config = ObjectToolsConfig.createFromXml((String)element.getData());
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e);
            this.config = new ObjectToolsConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.config);
        GridLayout layout = new GridLayout();
        layout.numColumns = this.config.getNumColumns();
        this.getContentArea().setLayout((Layout)layout);
        if (this.config.getTools() != null) {
            for (ObjectToolsConfig.Tool t : this.config.getTools()) {
                this.createToolButton(t);
            }
        }
    }

    private void createToolButton(ObjectToolsConfig.Tool t) {
        Button b = new Button(this.getContentArea(), 0x800008);
        b.setText(t.name);
        b.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        b.setLayoutData((Object)new GridData(4, 4, true, false));
        if (t.color > 0) {
            b.setBackground(this.colors.create(ColorConverter.rgbFromInt((int)t.color)));
        }
    }

    protected void executeTool(ObjectToolsConfig.Tool t) {
        ObjectTool tool = ObjectToolsCache.getInstance().findTool(t.toolId);
        if (tool == null) {
            return;
        }
        AbstractObject object = Registry.getSession().findObjectById(this.getEffectiveObjectId(t.objectId));
        if (object == null) {
            return;
        }
        HashSet<ObjectContext> allObjects = new HashSet<ObjectContext>();
        HashSet<ObjectContext> nodes = new HashSet<ObjectContext>();
        if (object instanceof AbstractNode) {
            ObjectContext oc = new ObjectContext((AbstractObject)((AbstractNode)object), null, this.getDashboardObjectId());
            nodes.add(oc);
            allObjects.add(oc);
        } else if (object instanceof Container || object instanceof ServiceRoot || object instanceof Subnet || object instanceof Cluster) {
            for (AbstractObject n : object.getAllChildren(2)) {
                ObjectContext oc = new ObjectContext((AbstractObject)((AbstractNode)n), null, this.getDashboardObjectId());
                nodes.add(oc);
                allObjects.add(oc);
                allObjects.add(new ObjectContext((AbstractObject)((AbstractNode)object), null, this.getDashboardObjectId()));
            }
        }
        ObjectToolExecutor.execute(allObjects, nodes, (ObjectTool)tool, (ViewPlacement)new ViewPlacement((View)this.view));
    }
}

