/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.PortViewConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.modules.dashboards.widgets.PortViewElement;
import org.netxms.nxmc.modules.objects.ObjectContextMenuManager;
import org.netxms.nxmc.modules.objects.widgets.DeviceViewWidget;
import org.netxms.nxmc.modules.objects.widgets.helpers.PortSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class PortViewElement
extends ElementWidget {
    private static final Logger logger = LoggerFactory.getLogger(PortViewElement.class);
    private final I18n i18n = LocalizationHelper.getI18n(PortViewElement.class);
    private ScrolledComposite scroller;
    private Composite content;
    private Map<Long, DeviceViewWidget> deviceViews = new HashMap();
    private PortViewConfig config;
    private NXCSession session;
    private ISelectionProvider selectionProvider;
    private ISelection selection = new StructuredSelection();
    private Set<ISelectionChangedListener> selectionListeners = new HashSet();
    private MenuManager popupMenuManager;

    public PortViewElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        this.session = Registry.getSession();
        try {
            this.config = PortViewConfig.createFromXml((String)element.getData());
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e);
            this.config = new PortViewConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.config);
        this.selectionProvider = new /* Unavailable Anonymous Inner Class!! */;
        this.popupMenuManager = new ObjectContextMenuManager((View)view, this.selectionProvider, null);
        this.scroller = new ScrolledComposite(this.getContentArea(), 768);
        this.scroller.setBackground(this.getDisplay().getSystemColor(25));
        this.content = new Composite((Composite)this.scroller, 0);
        this.content.setBackground(this.getDisplay().getSystemColor(25));
        GridLayout contentLayout = new GridLayout();
        contentLayout.verticalSpacing = 12;
        this.content.setLayout((Layout)contentLayout);
        this.syncChildren();
        2 sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener((SessionListener)sessionListener);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void syncChildren() {
        AbstractObject root = this.session.findObjectById(this.getEffectiveObjectId(this.config.getRootObjectId()));
        if (root == null) {
            return;
        }
        ArrayList<AbstractObject> parentsForChildSync = new ArrayList<AbstractObject>();
        if (root instanceof Node) {
            if (((Node)root).isBridge()) {
                parentsForChildSync.add(root);
            }
        } else {
            ArrayList nodes = new ArrayList(root.getAllChildren(2));
            Collections.sort(nodes, new /* Unavailable Anonymous Inner Class!! */);
            for (AbstractObject o : nodes) {
                if (!((Node)o).isBridge()) continue;
                parentsForChildSync.add(o);
            }
        }
        5 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void buildView() {
        AbstractObject root = this.session.findObjectById(this.getEffectiveObjectId(this.config.getRootObjectId()));
        if (root instanceof Node) {
            if (((Node)root).isBridge()) {
                this.addDeviceView((Node)root);
            }
        } else {
            ArrayList nodes = new ArrayList(root.getAllChildren(2));
            Collections.sort(nodes, new /* Unavailable Anonymous Inner Class!! */);
            for (AbstractObject o : nodes) {
                if (!((Node)o).isBridge()) continue;
                this.addDeviceView((Node)o);
            }
        }
    }

    private boolean needRebuild() {
        AbstractObject root = this.session.findObjectById(this.getEffectiveObjectId(this.config.getRootObjectId()));
        if (root instanceof Node) {
            return !this.deviceViews.containsKey(root.getObjectId()) && ((Node)root).isBridge() || this.deviceViews.containsKey(root.getObjectId()) && !((Node)root).isBridge();
        }
        Set nodes = root.getAllChildren(2);
        for (AbstractObject o : nodes) {
            if (!(((Node)o).isBridge() ? !this.deviceViews.containsKey(o.getObjectId()) : this.deviceViews.containsKey(o.getObjectId()))) continue;
            return true;
        }
        for (Long id : this.deviceViews.keySet()) {
            boolean found = false;
            for (AbstractObject o : nodes) {
                if (o.getObjectId() != id.longValue()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    private void addDeviceView(Node n) {
        DeviceViewWidget d = new DeviceViewWidget(this.content, 0);
        d.setHeaderVisible(true);
        d.setNodeId(n.getObjectId());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        d.setLayoutData((Object)gd);
        Menu menu = this.popupMenuManager.createContextMenu((Control)d);
        d.setMenu(menu);
        d.addSelectionListener((PortSelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deviceViews.put(n.getObjectId(), d);
    }
}

