/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import org.netxms.client.dashboards.DashboardElement;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.StatusMapConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.widgets.AbstractObjectStatusMap;
import org.netxms.nxmc.modules.objects.widgets.FlatObjectStatusMap;
import org.netxms.nxmc.modules.objects.widgets.RadialObjectStatusMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusMapElement
extends ElementWidget {
    private static final Logger logger = LoggerFactory.getLogger(StatusMapElement.class);
    private AbstractObjectStatusMap map;
    private StatusMapConfig config;

    public StatusMapElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view, true);
        try {
            this.config = StatusMapConfig.createFromXml((String)element.getData());
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e);
            this.config = new StatusMapConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.config);
        this.map = this.config.isShowRadial() ? new RadialObjectStatusMap((ObjectView)view, this.getContentArea(), 0) : new FlatObjectStatusMap((ObjectView)view, this.getContentArea(), 0);
        this.map.setFitToScreen(this.config.isFitToScreen());
        if (!this.config.isShowRadial()) {
            ((FlatObjectStatusMap)this.map).setGroupObjects(this.config.isGroupObjects());
        }
        this.map.setHideObjectsInMaintenance(this.config.isHideObjectsInMaintenance());
        this.map.setSeverityFilter(this.config.getSeverityFilter());
        this.enableFilter(this.config.isShowTextFilter());
        this.map.setRootObjectId(this.getEffectiveObjectId(this.config.getObjectId()));
        this.map.refresh();
        this.map.addRefreshListener((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void onFilterModify() {
        this.map.setTextFilter(this.getFilterText());
    }
}

