/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.datacollection.Threshold;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.dialogs.EditThresholdDialog;
import org.netxms.nxmc.modules.events.widgets.EventSelector;
import org.netxms.nxmc.modules.nxsl.dialogs.ScriptEditDialog;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.NumericTextFieldValidator;
import org.netxms.nxmc.tools.TextFieldValidator;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class EditThresholdDialog
extends Dialog {
    private static I18n i18n = LocalizationHelper.getI18n(EditThresholdDialog.class);
    private Threshold threshold;
    private Combo function;
    private Combo operation;
    private Text samples;
    private Text value;
    private LabeledText script;
    private Group conditionGroup;
    private Composite scriptGroup;
    private EventSelector activationEvent;
    private EventSelector deactivationEvent;
    private Text repeatInterval;
    private Button repeatDefault;
    private Button repeatNever;
    private Button repeatCustom;
    private int selectedFunction;
    private String savedScript = null;
    private int savedOperation = -1;
    private String savedValue = null;

    public EditThresholdDialog(Shell parentShell, Threshold threshold) {
        super(parentShell);
        this.threshold = threshold;
        this.selectedFunction = threshold.getFunction();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout dialogLayout = new GridLayout();
        dialogArea.setLayout((Layout)dialogLayout);
        this.conditionGroup = new Group(dialogArea, 0);
        this.conditionGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.conditionGroup.setText(i18n.tr("Condition"));
        GridLayout condLayout = new GridLayout();
        condLayout.numColumns = 2;
        condLayout.makeColumnsEqualWidth = true;
        this.conditionGroup.setLayout((Layout)condLayout);
        this.function = WidgetHelper.createLabeledCombo((Composite)this.conditionGroup, (int)2060, (String)i18n.tr("Function"), (Object)"WidgetHelper::default_layout_data");
        this.function.add(i18n.tr("Last polled value"));
        this.function.add(i18n.tr("Average value"));
        this.function.add(i18n.tr("Mean deviation"));
        this.function.add(i18n.tr("Diff with previous value"));
        this.function.add(i18n.tr("Data collection error"));
        this.function.add(i18n.tr("Sum of values"));
        this.function.add(i18n.tr("Script"));
        this.function.add(i18n.tr("Absolute deviation"));
        this.function.select(this.threshold.getFunction());
        this.function.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.samples = WidgetHelper.createLabeledText((Composite)this.conditionGroup, (int)2048, (int)60, (String)i18n.tr("Samples"), (String)Integer.toString(this.threshold.getSampleCount()), (Object)"WidgetHelper::default_layout_data");
        this.samples.setTextLimit(5);
        if (this.threshold.getFunction() == 6) {
            this.createScriptGroup();
        } else {
            this.createOperGroup(this.threshold.getFunction());
        }
        Group eventGroup = new Group(dialogArea, 0);
        eventGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        eventGroup.setText(i18n.tr("Event"));
        GridLayout eventLayout = new GridLayout();
        eventGroup.setLayout((Layout)eventLayout);
        this.activationEvent = new EventSelector((Composite)eventGroup, 0);
        this.activationEvent.setLabel(i18n.tr("Activation event"));
        this.activationEvent.setEventCode((long)this.threshold.getFireEvent());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.widthHint = 550;
        this.activationEvent.setLayoutData((Object)gd);
        this.deactivationEvent = new EventSelector((Composite)eventGroup, 0);
        this.deactivationEvent.setLabel(i18n.tr("Deactivation event"));
        this.deactivationEvent.setEventCode((long)this.threshold.getRearmEvent());
        this.deactivationEvent.setLayoutData((Object)gd);
        Group repeatGroup = new Group(dialogArea, 0);
        repeatGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        repeatGroup.setText(i18n.tr("Repeat event"));
        GridLayout repeatLayout = new GridLayout();
        repeatLayout.numColumns = 3;
        repeatGroup.setLayout((Layout)repeatLayout);
        this.repeatDefault = new Button((Composite)repeatGroup, 16);
        this.repeatDefault.setText(i18n.tr("Use &default settings"));
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.horizontalSpan = 3;
        this.repeatDefault.setLayoutData((Object)gd);
        this.repeatDefault.setSelection(this.threshold.getRepeatInterval() == -1);
        this.repeatNever = new Button((Composite)repeatGroup, 16);
        this.repeatNever.setText(i18n.tr("&Never"));
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.horizontalSpan = 3;
        this.repeatNever.setLayoutData((Object)gd);
        this.repeatNever.setSelection(this.threshold.getRepeatInterval() == 0);
        this.repeatCustom = new Button((Composite)repeatGroup, 16);
        this.repeatCustom.setText(i18n.tr("&Every"));
        this.repeatCustom.setSelection(this.threshold.getRepeatInterval() > 0);
        this.repeatCustom.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.repeatInterval = new Text((Composite)repeatGroup, 2048);
        this.repeatInterval.setTextLimit(5);
        this.repeatInterval.setText(this.threshold.getRepeatInterval() > 0 ? Integer.toString(this.threshold.getRepeatInterval()) : "3600");
        this.repeatInterval.setEnabled(this.threshold.getRepeatInterval() > 0);
        new Label((Composite)repeatGroup, 0).setText(i18n.tr("seconds"));
        return dialogArea;
    }

    private void createOperGroup(int function) {
        this.operation = WidgetHelper.createLabeledCombo((Composite)this.conditionGroup, (int)2060, (String)i18n.tr("Operation"), (Object)"WidgetHelper::default_layout_data");
        this.operation.add(i18n.tr("<  : less than"));
        this.operation.add(i18n.tr("<= : less than or equal to"));
        this.operation.add(i18n.tr("== : equal to"));
        this.operation.add(i18n.tr(">= : greater than or equal to"));
        this.operation.add(i18n.tr(">  : greater than"));
        this.operation.add(i18n.tr("!= : not equal to"));
        this.operation.add(i18n.tr("like"));
        this.operation.add(i18n.tr("not like"));
        this.operation.select(this.savedOperation != -1 ? this.savedOperation : this.threshold.getOperation());
        this.operation.setEnabled(function != 4);
        this.value = WidgetHelper.createLabeledText((Composite)this.conditionGroup, (int)2048, (int)120, (String)i18n.tr("Value"), (String)(this.savedValue != null ? this.savedValue : this.threshold.getValue()), (Object)"WidgetHelper::default_layout_data");
        this.value.setEnabled(function != 4);
    }

    private void disposeOperGroup() {
        this.savedOperation = this.operation.getSelectionIndex();
        this.savedValue = this.value.getText();
        this.operation.getParent().dispose();
        this.value.getParent().dispose();
    }

    private void createScriptGroup() {
        this.scriptGroup = new Composite((Composite)this.conditionGroup, 0);
        this.scriptGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout scriptLayout = new GridLayout();
        scriptLayout.numColumns = 2;
        scriptLayout.marginHeight = 0;
        scriptLayout.marginWidth = 0;
        scriptLayout.horizontalSpacing = 2;
        this.scriptGroup.setLayout((Layout)scriptLayout);
        this.script = new LabeledText(this.scriptGroup, 0);
        this.script.setLabel(i18n.tr("Script"));
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 400;
        this.script.setLayoutData((Object)gd);
        this.script.setText(this.savedScript != null ? this.savedScript : this.threshold.getScript());
        Button editButton = new Button(this.scriptGroup, 8);
        editButton.setImage(SharedIcons.IMG_EDIT);
        gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.horizontalAlignment = 4;
        gd.heightHint = this.script.getTextControl().computeSize((int)-1, (int)-1).y;
        editButton.setLayoutData((Object)gd);
        editButton.setToolTipText(i18n.tr("Open script editor (Ctrl+E)"));
        editButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        4 keyListener = new /* Unavailable Anonymous Inner Class!! */;
        editButton.getDisplay().addFilter(1, (Listener)keyListener);
        editButton.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.value = WidgetHelper.createLabeledText((Composite)this.conditionGroup, (int)2048, (int)120, (String)i18n.tr("Value"), (String)(this.savedValue != null ? this.savedValue : this.threshold.getValue()), (Object)"WidgetHelper::default_layout_data");
    }

    private void openScriptEditor() {
        ScriptEditDialog dlg = new ScriptEditDialog(this.getShell(), this.script.getText(), "Variables:\r\n\t$1\t\t\tcurrent DCI value;\r\n\t$2\t\t\tthreshold value;\r\n\t$dci\t\t\tthis DCI object;\r\n\t$isCluster\ttrue if DCI is on cluster;\r\n\t$node\t\tcurrent node object (null if DCI is not on the node);\r\n\t$object\t\tcurrent object.\r\n\r\nReturn value: true if threshold violated.");
        if (dlg.open() == 0) {
            this.script.setText(dlg.getScript());
        }
    }

    private void disposeScriptGroup() {
        this.savedScript = this.script.getText();
        this.scriptGroup.dispose();
        this.value.getParent().dispose();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(i18n.tr("Edit Threshold"));
    }

    protected void okPressed() {
        int rpt;
        if (!WidgetHelper.validateTextInput((Text)this.samples, (TextFieldValidator)new NumericTextFieldValidator(1L, 1000L))) {
            WidgetHelper.adjustWindowSize((Window)this);
            return;
        }
        if (this.repeatDefault.getSelection()) {
            rpt = -1;
        } else if (this.repeatNever.getSelection()) {
            rpt = 0;
        } else {
            if (!WidgetHelper.validateTextInput((Text)this.repeatInterval, (TextFieldValidator)new NumericTextFieldValidator(1L, 1000000L))) {
                WidgetHelper.adjustWindowSize((Window)this);
                return;
            }
            rpt = Integer.parseInt(this.repeatInterval.getText());
        }
        this.threshold.setFunction(this.function.getSelectionIndex());
        if (this.threshold.getFunction() == 6) {
            this.threshold.setScript(this.script.getText());
            this.threshold.setValue(this.value.getText());
        } else {
            this.threshold.setOperation(this.operation.getSelectionIndex());
            this.threshold.setValue(this.value.getText());
        }
        this.threshold.setSampleCount(Integer.parseInt(this.samples.getText()));
        this.threshold.setRepeatInterval(rpt);
        this.threshold.setFireEvent((int)this.activationEvent.getEventCode());
        this.threshold.setRearmEvent((int)this.deactivationEvent.getEventCode());
        super.okPressed();
    }
}

