/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.MaintenanceMenuManager;
import org.netxms.nxmc.modules.objects.dialogs.MaintanenceScheduleDialog;
import org.xnap.commons.i18n.I18n;

public class MaintenanceMenuManager
extends MenuManager {
    private static final I18n i18n = LocalizationHelper.getI18n(MaintenanceMenuManager.class);
    private View view;
    private ISelectionProvider selectionProvider;
    private Action actionEnterMaintenance;
    private Action actionLeaveMaintenance;
    private Action actionScheduleMaintenance;
    private ArrayList<Action> actionMaintenance;

    public MaintenanceMenuManager(View view, ISelectionProvider selectionProvider) {
        this.view = view;
        this.selectionProvider = selectionProvider;
        this.setMenuText(i18n.tr("M&aintenance"));
        this.createActions();
        this.add((IAction)this.actionEnterMaintenance);
        this.add((IAction)this.actionLeaveMaintenance);
        this.add((IContributionItem)new Separator());
        for (Action action : this.actionMaintenance) {
            this.add((IAction)action);
        }
        this.add((IContributionItem)new Separator());
        this.add((IAction)this.actionScheduleMaintenance);
    }

    protected void createActions() {
        this.actionEnterMaintenance = new /* Unavailable Anonymous Inner Class!! */;
        this.actionLeaveMaintenance = new /* Unavailable Anonymous Inner Class!! */;
        this.actionScheduleMaintenance = new /* Unavailable Anonymous Inner Class!! */;
        this.initializeTimeMaintenance();
    }

    private void changeObjectMaintenanceState(boolean enter) {
        String comments;
        if (enter) {
            InputDialog dlg = new InputDialog(null, i18n.tr("Enter Maintenance"), i18n.tr("Additional comments"), "", null);
            if (dlg.open() != 0) {
                return;
            }
            comments = dlg.getValue().trim();
        } else {
            comments = null;
        }
        Object[] objects = ((IStructuredSelection)this.selectionProvider.getSelection()).toArray();
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void scheduleMaintenance() {
        MaintanenceScheduleDialog dialog = new MaintanenceScheduleDialog(this.view.getWindow().getShell());
        if (dialog.open() != 0) {
            return;
        }
        Object[] objects = ((IStructuredSelection)this.selectionProvider.getSelection()).toArray();
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void initializeTimeMaintenance() {
        PreferenceStore settings = PreferenceStore.getInstance();
        int menuSize = settings.getAsInteger("Maintenance.TimeMenuSize", 0);
        this.actionMaintenance = new ArrayList(menuSize);
        for (int i = 0; i < menuSize; ++i) {
            int time = settings.getAsInteger("Maintenance.TimeMenuEntry." + Integer.toString(i), 0);
            if (time == 0) continue;
            this.actionMaintenance.add(this.createTimeMaintenanceAction(time, i));
        }
    }

    private Action createTimeMaintenanceAction(int time, int index) {
        6 action = new /* Unavailable Anonymous Inner Class!! */;
        action.setId("Maintenance.TimeMenuEntry." + Integer.toString(index));
        return action;
    }

    private void scheduleMaintenance(int time) {
        InputDialog dlg = new InputDialog(null, i18n.tr("Enter Maintenance"), i18n.tr("Additional comments"), "", null);
        if (dlg.open() != 0) {
            return;
        }
        String comments = dlg.getValue().trim();
        Object[] objects = ((IStructuredSelection)this.selectionProvider.getSelection()).toArray();
        NXCSession session = Registry.getSession();
        long timestamp = System.currentTimeMillis() + (long)(time * 1000);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }
}

