/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectSelectionFilterFactory;
import org.netxms.nxmc.modules.objects.widgets.ObjectTree;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class ObjectSelectionDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(ObjectSelectionDialog.class);
    private NXCSession session;
    private ObjectTree objectTree;
    private long[] selectedObjects;
    private Set<Integer> classFilter;
    private boolean multiSelection;
    private boolean showFilterToolTip = true;
    private boolean showFilterCloseButton = false;
    private List<AbstractObject> blockedObjects;
    private String title = this.i18n.tr("Select Object");

    public static Set<Integer> createNodeSelectionFilter(boolean allowMobileDevices) {
        return ObjectSelectionFilterFactory.getInstance().createNodeSelectionFilter(allowMobileDevices);
    }

    public static Set<Integer> createZoneSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createZoneSelectionFilter();
    }

    public static Set<Integer> createNetworkMapSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createNetworkMapSelectionFilter();
    }

    public static Set<Integer> createNetworkMapGroupsSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createNetworkMapGroupsSelectionFilter();
    }

    public static Set<Integer> createAssetGroupsSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createAssetGroupsSelectionFilter();
    }

    public static Set<Integer> createDashboardGroupSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createDashboardGroupSelectionFilter();
    }

    public static Set<Integer> createDashboardSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createDashboardSelectionFilter();
    }

    public static Set<Integer> createTemplateSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createTemplateSelectionFilter();
    }

    public static Set<Integer> createTemplateGroupSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createTemplateGroupSelectionFilter();
    }

    public static Set<Integer> createDataCollectionOwnerSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createDataCollectionOwnerSelectionFilter();
    }

    public static Set<Integer> createDataCollectionTargetSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createDataCollectionTargetSelectionFilter();
    }

    public static Set<Integer> createContainerSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createContainerSelectionFilter();
    }

    public static Set<Integer> createBusinessServiceSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createBusinessServiceSelectionFilter();
    }

    public static Set<Integer> createDashboardAndNetworkMapSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createDashboardAndNetworkMapSelectionFilter();
    }

    public static Set<Integer> createRackSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createRackSelectionFilter();
    }

    public static Set<Integer> createRackOrChassisSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createRackOrChassisSelectionFilter();
    }

    public static Set<Integer> createAssetSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createAssetSelectionFilter();
    }

    public ObjectSelectionDialog(Shell parentShell) {
        this(parentShell, null, null);
    }

    public ObjectSelectionDialog(Shell parentShell, Set<Integer> classFilter) {
        this(parentShell, classFilter, null);
    }

    public ObjectSelectionDialog(Shell parentShell, Set<Integer> classFilter, List<AbstractObject> blockedObjects) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.classFilter = classFilter;
        this.multiSelection = true;
        this.session = Registry.getSession();
        this.blockedObjects = blockedObjects;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        PreferenceStore settings = PreferenceStore.getInstance();
        newShell.setSize(settings.getAsPoint("ObjectSelectionDialog.Size", 400, 350));
    }

    protected Control createDialogArea(Composite parent) {
        PreferenceStore settings = PreferenceStore.getInstance();
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.objectTree = new ObjectTree(dialogArea, 0, this.multiSelection ? 2 : 0, this.classFilter, null, this.showFilterToolTip, this.showFilterCloseButton);
        String text = settings.getAsString("ObjectSelectionDialog.Filter");
        if (text != null) {
            this.objectTree.setFilterText(text);
        }
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.objectTree.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        if (this.multiSelection) {
            Long[] objects = this.objectTree.getSelectedObjects();
            this.selectedObjects = new long[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                this.selectedObjects[i] = objects[i];
            }
        } else {
            long objectId = this.objectTree.getFirstSelectedObject();
            if (objectId != 0L) {
                if (this.blockedObjects != null) {
                    for (int i = 0; i < this.blockedObjects.size(); ++i) {
                        if (((AbstractObject)this.blockedObjects.get(i)).getObjectId() != objectId) continue;
                        MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Same object was selected as move source and move target."));
                        return;
                    }
                }
                this.selectedObjects = new long[1];
                this.selectedObjects[0] = objectId;
            } else {
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please select object and then press OK."));
                return;
            }
        }
        this.saveSettings();
        super.okPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set("ObjectSelectionDialog.Size", size);
        settings.set("ObjectSelectionDialog.Filter", this.objectTree.getFilterText());
    }

    public List<AbstractObject> getSelectedObjects() {
        if (this.selectedObjects == null) {
            return new ArrayList<AbstractObject>(0);
        }
        return this.session.findMultipleObjects(this.selectedObjects, false);
    }

    public AbstractObject[] getSelectedObjects(Class<? extends AbstractObject> classFilter) {
        HashSet<Class<? extends AbstractObject>> classFilterSet = new HashSet<Class<? extends AbstractObject>>();
        classFilterSet.add(classFilter);
        return this.getSelectedObjects(classFilterSet);
    }

    public AbstractObject[] getSelectedObjects(Set<Class<? extends AbstractObject>> classFilterSet) {
        if (this.selectedObjects == null) {
            return new AbstractObject[0];
        }
        HashSet<AbstractObject> resultSet = new HashSet<AbstractObject>(this.selectedObjects.length);
        for (int i = 0; i < this.selectedObjects.length; ++i) {
            AbstractObject object = this.session.findObjectById(this.selectedObjects[i]);
            for (Class<? extends AbstractObject> cl : classFilterSet) {
                if (!cl.isInstance(object)) continue;
                resultSet.add(object);
            }
        }
        return resultSet.toArray(new AbstractObject[resultSet.size()]);
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelection;
    }

    public void enableMultiSelection(boolean enable) {
        this.multiSelection = enable;
    }

    public void showFilterToolTip(boolean showFilterToolTip) {
        this.showFilterToolTip = showFilterToolTip;
    }

    public void showFilterCloseButton(boolean showFilterCloseButton) {
        this.showFilterCloseButton = showFilterCloseButton;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

