/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.elements;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.constants.SpanningTreePortState;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.Asset;
import org.netxms.client.objects.BusinessService;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.elements.OverviewPageElement;
import org.netxms.nxmc.modules.objects.views.elements.TableElement;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.xnap.commons.i18n.I18n;

public class ObjectState
extends TableElement {
    private static final I18n i18n = LocalizationHelper.getI18n(ObjectState.class);
    private static final String[] ifaceExpectedState = new String[]{i18n.tr("Up"), i18n.tr("Down"), i18n.tr("Ignore"), i18n.tr("Auto")};

    public ObjectState(Composite parent, OverviewPageElement anchor, ObjectView objectView) {
        super(parent, anchor, objectView);
    }

    protected void fillTable() {
        AbstractObject object = this.getObject();
        NXCSession session = Registry.getSession();
        if (object.isInMaintenanceMode()) {
            this.addPair(i18n.tr("Status"), StatusDisplayInfo.getStatusText((ObjectStatus)object.getStatus()) + i18n.tr(" (maintenance)"));
            AbstractUserObject user = session.findUserDBObjectById(object.getMaintenanceInitiatorId(), (Runnable)new /* Unavailable Anonymous Inner Class!! */);
            this.addPair(i18n.tr("Maintenance initiator"), (String)(user != null ? user.getName() : "[" + object.getMaintenanceInitiatorId() + "]"));
        } else {
            this.addPair(i18n.tr("Status"), StatusDisplayInfo.getStatusText((ObjectStatus)object.getStatus()));
        }
        switch (object.getObjectClass()) {
            case 33: {
                AccessPoint ap = (AccessPoint)object;
                this.addPair(i18n.tr("State"), ap.getState().toString());
                break;
            }
            case 16: {
                Asset asset = (Asset)object;
                if (asset.getLastUpdateTimestamp() == null || asset.getLastUpdateTimestamp().getTime() == 0L) break;
                this.addPair(i18n.tr("Last updated"), DateFormatFactory.getDateTimeFormat().format(asset.getLastUpdateTimestamp()));
                AbstractUserObject user = session.findUserDBObjectById(asset.getLastUpdateUserId(), () -> this.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */));
                this.addPair(i18n.tr("Updated by"), (String)(user != null ? user.getName() : "[" + asset.getLastUpdateUserId() + "]"));
                break;
            }
            case 28: {
                BusinessService businessService = (BusinessService)object;
                this.addPair(i18n.tr("Service state"), businessService.getServiceState().toString());
                break;
            }
            case 3: {
                AbstractNode node;
                Interface iface = (Interface)object;
                this.addPair(i18n.tr("Administrative state"), iface.getAdminStateAsText());
                this.addPair(i18n.tr("Operational state"), iface.getOperStateAsText());
                this.addPair(i18n.tr("Expected state"), ifaceExpectedState[iface.getExpectedState()]);
                if (iface.isPhysicalPort() && (node = iface.getParentNode()) != null) {
                    if (node.isBridge() && iface.getStpPortState() != SpanningTreePortState.UNKNOWN) {
                        this.addPair(i18n.tr("Spanning Tree port state"), iface.getStpPortState().getText());
                    }
                    if (node.is8021xSupported()) {
                        this.addPair(i18n.tr("802.1x PAE state"), iface.getDot1xPaeStateAsText());
                        this.addPair(i18n.tr("802.1x backend state"), iface.getDot1xBackendStateAsText());
                    }
                }
                if (!iface.isOSPF()) break;
                this.addPair(i18n.tr("OSPF interface state"), iface.getOSPFState().getText(), false);
                break;
            }
            case 2: {
                AbstractNode node = (AbstractNode)object;
                if ((node.getCapabilities() & 0x800000) != 0) {
                    this.addPair(i18n.tr("Device state"), ((AbstractNode)object).getCipStateText(), false);
                    this.addPair(i18n.tr("Device status"), ((AbstractNode)object).getCipStatusText(), false);
                    if ((((AbstractNode)object).getCipStatus() >> 4 & 0xF) != 0) {
                        this.addPair(i18n.tr("Extended device status"), ((AbstractNode)object).getCipExtendedStatusText(), false);
                    }
                }
                if (node.getBootTime() != null) {
                    this.addPair(i18n.tr("Boot time"), DateFormatFactory.getDateTimeFormat().format(node.getBootTime()), false);
                }
                if (node.hasAgent()) {
                    this.addPair(i18n.tr("Agent status"), (node.getStateFlags() & 0x10000) != 0 ? i18n.tr("Unreachable") : i18n.tr("Connected"));
                }
                if (node.getLastAgentCommTime() == null) break;
                this.addPair(i18n.tr("Last agent contact"), DateFormatFactory.getDateTimeFormat().format(node.getLastAgentCommTime()), false);
                break;
            }
            case 31: {
                MobileDevice md = (MobileDevice)object;
                if (md.getLastReportTime().getTime() == 0L) {
                    this.addPair(i18n.tr("Last report"), i18n.tr("Never"));
                } else {
                    this.addPair(i18n.tr("Last report"), DateFormatFactory.getDateTimeFormat().format(md.getLastReportTime()));
                }
                if (md.getBatteryLevel() < 0) break;
                this.addPair(i18n.tr("Battery level"), Integer.toString(md.getBatteryLevel()) + "%");
                break;
            }
        }
    }

    protected String getTitle() {
        return i18n.tr("State");
    }
}

