/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import java.net.InetAddress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.NXCSession;
import org.netxms.client.topology.WirelessStation;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.tools.ComparatorHelper;

public class WirelessStationComparator
extends ViewerComparator {
    private NXCSession session = Registry.getSession();

    public int compare(Viewer viewer, Object e1, Object e2) {
        WirelessStation ws1 = (WirelessStation)e1;
        WirelessStation ws2 = (WirelessStation)e2;
        int result = switch ((Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID")) {
            case 0 -> ws1.getMacAddress().compareTo(ws2.getMacAddress());
            case 1 -> this.getVendor(ws1).compareToIgnoreCase(this.getVendor(ws2));
            case 2 -> ComparatorHelper.compareInetAddresses((InetAddress)ws1.getIpAddress(), (InetAddress)ws2.getIpAddress());
            case 3 -> this.session.getObjectName(ws1.getNodeObjectId()).compareToIgnoreCase(this.session.getObjectName(ws2.getNodeObjectId()));
            case 4 -> this.session.getObjectName(ws1.getAccessPointId()).compareToIgnoreCase(this.session.getObjectName(ws2.getAccessPointId()));
            case 6 -> ws1.getSsid().compareToIgnoreCase(ws2.getSsid());
            case 5 -> ws1.getRadioInterface().compareToIgnoreCase(ws2.getRadioInterface());
            default -> 0;
        };
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }

    private String getVendor(WirelessStation ws) {
        String vendor = this.session.getVendorByMac(ws.getMacAddress(), null);
        return vendor != null ? vendor : "";
    }
}

