/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.worldmap.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.netxms.base.GeoLocation;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.worldmap.GeoMapListener;
import org.netxms.nxmc.modules.worldmap.tools.MapAccessor;
import org.netxms.nxmc.modules.worldmap.views.WorldMapView;
import org.netxms.nxmc.modules.worldmap.widgets.ObjectGeoLocationViewer;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class WorldMapView
extends View {
    private static final I18n i18n = LocalizationHelper.getI18n(WorldMapView.class);
    public static final String ID = "WorldMap";
    private ObjectGeoLocationViewer map;
    private MapAccessor mapAccessor;
    private PreferenceStore settings = PreferenceStore.getInstance();
    private int zoomLevel = 3;
    private Action actionPlaceObject;
    private Action actionZoomIn;
    private Action actionZoomOut;

    public WorldMapView() {
        super(i18n.tr("World Map"), ResourceManager.getImageDescriptor((String)"icons/worldmap.png"), ID, true);
    }

    protected void createContent(Composite parent) {
        this.map = new ObjectGeoLocationViewer(parent, 0, (View)this);
        this.createActions();
        this.createPopupMenu();
        this.mapAccessor = new MapAccessor(new GeoLocation(this.settings.getAsDouble("WorldMap.latitude", 0.0), this.settings.getAsDouble("WorldMap.longitude", 0.0)));
        this.zoomLevel = this.settings.getAsInteger("WorldMap.zoom", 3);
        this.mapAccessor.setZoom(this.zoomLevel);
        this.map.showMap(this.mapAccessor);
        this.map.addMapListener((GeoMapListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void createActions() {
        this.actionPlaceObject = new /* Unavailable Anonymous Inner Class!! */;
        this.actionZoomIn = new /* Unavailable Anonymous Inner Class!! */;
        this.actionZoomOut = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createPopupMenu() {
        5 menuMgr = new /* Unavailable Anonymous Inner Class!! */;
        Menu menu = menuMgr.createContextMenu((Control)this.map);
        this.map.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionPlaceObject);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        super.fillLocalToolBar(manager);
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
    }

    public void dispose() {
        this.settings.set("WorldMap.zoom", this.mapAccessor.getZoom());
        this.settings.set("WorldMap.latitude", this.mapAccessor.getLatitude());
        this.settings.set("WorldMap.longitude", this.mapAccessor.getLongitude());
        super.dispose();
    }

    private void placeObject() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getWindow().getShell(), ObjectSelectionDialog.createDataCollectionTargetSelectionFilter());
        if (dlg.open() == 0) {
            NXCObjectModificationData md = new NXCObjectModificationData(((AbstractObject)dlg.getSelectedObjects().get(0)).getObjectId());
            md.setGeolocation(this.map.getLocationAtPoint(this.map.getCurrentPoint()));
            NXCSession session = Registry.getSession();
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    protected void onFilterModify() {
        this.map.setFilterString(this.getFilterText().trim().toLowerCase());
        this.map.reloadMap();
    }

    private void setZoomLevel(int newLevel) {
        if (newLevel < 0 || newLevel > 19) {
            return;
        }
        this.zoomLevel = newLevel;
        this.mapAccessor.setZoom(this.zoomLevel);
        this.map.showMap(this.mapAccessor);
        this.actionZoomIn.setEnabled(this.zoomLevel < 19);
        this.actionZoomOut.setEnabled(this.zoomLevel > 0);
    }
}

