/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.views;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.objects.Dashboard;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.views.DashboardControlOwner;
import org.netxms.ui.eclipse.dashboard.views.DashboardNavigator;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.IntermediateSelectionProvider;

public class DashboardDynamicView
extends ViewPart
implements DashboardControlOwner {
    public static final String ID = "org.netxms.ui.eclipse.dashboard.views.DashboardDynamicView";
    private IntermediateSelectionProvider selectionProvider;
    private Dashboard dashboard = null;
    private ScrolledComposite scroller = null;
    private DashboardControl dbc = null;
    private ISelectionService selectionService;
    private ISelectionListener selectionListener;
    private Composite parentComposite;
    private RefreshAction actionRefresh;

    public void createPartControl(Composite parent) {
        this.selectionProvider = new IntermediateSelectionProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.parentComposite = parent;
        if (this.dashboard != null) {
            this.rebuildDashboard();
        }
        this.createActions();
        this.contributeToActionBars();
        this.selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                Object object;
                if (part instanceof DashboardNavigator && selection instanceof IStructuredSelection && !selection.isEmpty() && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof Dashboard) {
                    DashboardDynamicView.this.setObject((Dashboard)object);
                }
            }
        };
        this.selectionService.addSelectionListener(this.selectionListener);
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                DashboardDynamicView.this.rebuildDashboard();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    public void setFocus() {
        if (this.dbc != null && !this.dbc.isDisposed()) {
            this.dbc.setFocus();
        }
    }

    private void setObject(Dashboard object) {
        this.dashboard = object;
        this.rebuildDashboard();
    }

    private void rebuildDashboard() {
        if (this.dashboard == null) {
            return;
        }
        if (this.dbc != null) {
            this.dbc.dispose();
        }
        this.dashboard = (Dashboard)ConsoleSharedData.getSession().findObjectById(this.dashboard.getObjectId(), Dashboard.class);
        if (this.dashboard == null) {
            this.dbc = null;
            return;
        }
        Messages.get();
        this.setPartName(String.valueOf(Messages.DashboardDynamicView_PartNamePrefix) + this.dashboard.getObjectName());
        if (this.scroller != null && !this.dashboard.isScrollable()) {
            this.scroller.dispose();
            this.scroller = null;
        } else if (this.scroller == null && this.dashboard.isScrollable()) {
            this.scroller = new ScrolledComposite(this.parentComposite, 512);
            this.scroller.setExpandHorizontal(true);
            this.scroller.setExpandVertical(true);
            this.scroller.getVerticalBar().setIncrement(20);
            this.parentComposite.layout(true, true);
        }
        this.dbc = new DashboardControl((Composite)(this.dashboard.isScrollable() ? this.scroller : this.parentComposite), 0, this.dashboard, null, (IViewPart)this, this.selectionProvider, false);
        if (this.dashboard.isScrollable()) {
            this.scroller.setContent((Control)this.dbc);
            this.scroller.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    DashboardDynamicView.this.updateScroller();
                }
            });
            this.updateScroller();
        } else {
            this.parentComposite.layout();
        }
    }

    private void updateScroller() {
        this.dbc.layout(true, true);
        Rectangle r = this.scroller.getClientArea();
        Point s = this.dbc.computeSize(r.width, -1);
        this.scroller.setMinSize(s);
    }

    public void dispose() {
        if (this.selectionService != null && this.selectionListener != null) {
            this.selectionService.removeSelectionListener(this.selectionListener);
        }
        super.dispose();
    }

    @Override
    public void requestDashboardLayout() {
        if (this.scroller != null) {
            this.updateScroller();
        } else {
            this.parentComposite.layout(true, true);
        }
    }
}

