/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets.internal;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.netxms.client.xml.XMLTools;
import org.netxms.ui.eclipse.dashboard.dialogs.helpers.ObjectIdMatchingData;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementConfig;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Serializer;

public class AlarmViewerConfig
extends DashboardElementConfig {
    @Element(required=true)
    private long objectId = 0L;
    @Element(required=false)
    private int severityFilter = 255;
    @Element(required=false)
    private int stateFilter = 255;
    @Element(required=false)
    private boolean isLocalSoundEnabled = false;

    public static AlarmViewerConfig createFromXml(String xml) throws Exception {
        Serializer serializer = XMLTools.createSerializer();
        return (AlarmViewerConfig)serializer.read(AlarmViewerConfig.class, xml);
    }

    @Override
    public String createXml() throws Exception {
        Serializer serializer = XMLTools.createSerializer();
        StringWriter writer = new StringWriter();
        serializer.write((Object)this, (Writer)writer);
        return ((Object)writer).toString();
    }

    @Override
    public Set<Long> getObjects() {
        Set<Long> objects = super.getObjects();
        objects.add(this.objectId);
        return objects;
    }

    @Override
    public void remapObjects(Map<Long, ObjectIdMatchingData> remapData) {
        super.remapObjects(remapData);
        ObjectIdMatchingData md = remapData.get(this.objectId);
        if (md != null) {
            this.objectId = md.dstId;
        }
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }

    public int getSeverityFilter() {
        return this.severityFilter;
    }

    public void setSeverityFilter(int severityFilter) {
        this.severityFilter = severityFilter;
    }

    public int getStateFilter() {
        return this.stateFilter;
    }

    public void setStateFilter(int stateFilter) {
        this.stateFilter = stateFilter;
    }

    public boolean getIsLocalSoundEnabled() {
        return this.isLocalSoundEnabled;
    }

    public void setIsLocalSoundEnabled(boolean isLocalSoundEnabled) {
        this.isLocalSoundEnabled = isLocalSoundEnabled;
    }
}

