/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.util;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.Spliterators;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.imageio.ImageIO;
import org.apache.poi.common.usermodel.GenericRecord;
import org.apache.poi.sl.draw.BitmapImageRenderer;
import org.apache.poi.sl.draw.DrawPictureShape;
import org.apache.poi.sl.draw.Drawable;
import org.apache.poi.sl.draw.ImageRenderer;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.sl.usermodel.Slide;
import org.apache.poi.sl.usermodel.SlideShow;
import org.apache.poi.sl.usermodel.SlideShowFactory;
import org.apache.poi.util.GenericRecordJsonWriter;

public class PPTX2PNG {
    private static final String INPUT_PAT_REGEX = "(?<slideno>[^|]+)\\|(?<format>[^|]+)\\|(?<basename>.+)\\.(?<ext>[^.]++)";
    private static final Pattern INPUT_PATTERN = Pattern.compile("(?<slideno>[^|]+)\\|(?<format>[^|]+)\\|(?<basename>.+)\\.(?<ext>[^.]++)");
    private static final String OUTPUT_PAT_REGEX = "${basename}-${slideno}.${format}";

    private static void usage(String error) {
        String msg = "Usage: PPTX2PNG [options] <ppt or pptx file>\n" + (error == null ? "" : "Error: " + error + "\n") + "Options:\n    -scale <float>    scale factor\n    -fixSide <side>   specify side (long,short,width,height) to fix - use <scale> as amount of pixels\n    -slide <integer>  1-based index of a slide to render\n    -format <type>    png,gif,jpg (,null for testing)\n    -outdir <dir>     output directory, defaults to origin of the ppt/pptx file\n    -outfile <file>   output filename, defaults to '" + OUTPUT_PAT_REGEX + "'\n    -outpat <pattern> output filename pattern, defaults to '" + OUTPUT_PAT_REGEX + "'\n                      patterns: basename, slideno, format, ext\n    -dump <file>      dump the annotated records to a file\n    -quiet            do not write to console (for normal processing)";
        System.out.println(msg);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            PPTX2PNG.usage(null);
            return;
        }
        String slidenumStr = "-1";
        float scale = 1.0f;
        File file = null;
        String format = "png";
        File outdir = null;
        String outfile = null;
        boolean quiet = false;
        String outPattern = OUTPUT_PAT_REGEX;
        File dumpfile = null;
        String fixSide = "scale";
        block58: for (int i = 0; i < args.length; ++i) {
            String opt = i + 1 < args.length ? args[i + 1] : null;
            switch (args[i]) {
                case "-scale": {
                    scale = Float.parseFloat(opt);
                    ++i;
                    continue block58;
                }
                case "-slide": {
                    slidenumStr = opt;
                    ++i;
                    continue block58;
                }
                case "-format": {
                    format = opt;
                    ++i;
                    continue block58;
                }
                case "-outdir": {
                    outdir = new File(opt);
                    ++i;
                    continue block58;
                }
                case "-outfile": {
                    outfile = opt;
                    ++i;
                    continue block58;
                }
                case "-outpat": {
                    outPattern = opt;
                    ++i;
                    continue block58;
                }
                case "-quiet": {
                    quiet = true;
                    continue block58;
                }
                case "-dump": {
                    dumpfile = new File(opt);
                    ++i;
                    continue block58;
                }
                case "-fixside": {
                    fixSide = opt.toLowerCase(Locale.ROOT);
                    ++i;
                    continue block58;
                }
                default: {
                    file = new File(args[i]);
                }
            }
        }
        if (file == null || !file.exists()) {
            PPTX2PNG.usage("File not specified or it doesn't exist");
            return;
        }
        if (format == null || !format.matches("^(png|gif|jpg|null)$")) {
            PPTX2PNG.usage("Invalid format given");
            return;
        }
        if (outdir == null) {
            outdir = file.getParentFile();
        }
        if (!("null".equals(format) || outdir != null && outdir.exists() && outdir.isDirectory())) {
            PPTX2PNG.usage("Output directory doesn't exist");
            return;
        }
        if (scale < 0.0f) {
            PPTX2PNG.usage("Invalid scale given");
            return;
        }
        if (!"long,short,width,height,scale".contains(fixSide)) {
            PPTX2PNG.usage("<fixside> must be one of long / short / width / height");
            return;
        }
        if (!quiet) {
            System.out.println("Processing " + file);
        }
        try (MFProxy proxy = PPTX2PNG.initProxy(file);){
            double lenSide;
            Set<Integer> slidenum = proxy.slideIndexes(slidenumStr);
            if (slidenum.isEmpty()) {
                PPTX2PNG.usage("slidenum must be either -1 (for all) or within range: [1.." + proxy.getSlideCount() + "] for " + file);
                return;
            }
            Dimension2D pgsize = proxy.getSize();
            switch (fixSide) {
                default: {
                    lenSide = 1.0;
                    break;
                }
                case "long": {
                    lenSide = Math.max(pgsize.getWidth(), pgsize.getHeight());
                    break;
                }
                case "short": {
                    lenSide = Math.min(pgsize.getWidth(), pgsize.getHeight());
                    break;
                }
                case "width": {
                    lenSide = pgsize.getWidth();
                    break;
                }
                case "height": {
                    lenSide = pgsize.getHeight();
                }
            }
            int width = (int)Math.rint(pgsize.getWidth() * (double)scale / lenSide);
            int height = (int)Math.rint(pgsize.getHeight() * (double)scale / lenSide);
            for (int slideNo : slidenum) {
                proxy.setSlideNo(slideNo);
                if (!quiet) {
                    String title = proxy.getTitle();
                    System.out.println("Rendering slide " + slideNo + (title == null ? "" : ": " + title.trim()));
                }
                GenericRecord gr = proxy.getRoot();
                if (dumpfile != null) {
                    try (GenericRecordJsonWriter fw = new GenericRecordJsonWriter(dumpfile);){
                        if (gr == null) {
                            fw.writeError(file.getName() + " doesn't support GenericRecord interface and can't be dumped to a file.");
                        } else {
                            fw.write(gr);
                        }
                    }
                }
                BufferedImage img = new BufferedImage(width, height, 2);
                Graphics2D graphics = img.createGraphics();
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                graphics.setRenderingHint((RenderingHints.Key)Drawable.BUFFERED_IMAGE, new WeakReference<BufferedImage>(img));
                graphics.scale((double)scale / lenSide, (double)scale / lenSide);
                graphics.setComposite(AlphaComposite.Clear);
                graphics.fillRect(0, 0, width, height);
                graphics.setComposite(AlphaComposite.SrcOver);
                proxy.draw(graphics);
                if (!"null".equals(format)) {
                    String inname = String.format(Locale.ROOT, "%04d|%s|%s", slideNo, format, file.getName());
                    String outpat = proxy.getSlideCount() > 1 ? outPattern : outPattern.replaceAll("-?\\$\\{slideno\\}", "");
                    String outname = outfile != null ? outfile : INPUT_PATTERN.matcher(inname).replaceAll(outpat);
                    ImageIO.write((RenderedImage)img, format, new File(outdir, outname));
                }
                graphics.dispose();
                img.flush();
            }
        }
        catch (NoScratchpadException e) {
            PPTX2PNG.usage("'" + file.getName() + "': Format not supported - try to include poi-scratchpad.jar into the CLASSPATH.");
            return;
        }
        if (!quiet) {
            System.out.println("Done");
        }
    }

    private static MFProxy initProxy(File file) throws IOException {
        MFProxy proxy;
        String fileName = file.getName().toLowerCase(Locale.ROOT);
        switch (fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(46)) : "") {
            case ".emf": {
                proxy = new EMFHandler();
                break;
            }
            case ".wmf": {
                proxy = new WMFHandler();
                break;
            }
            default: {
                proxy = new PPTHandler();
            }
        }
        proxy.parse(file);
        return proxy;
    }

    private static class EMFHandler
    implements MFProxy {
        private ImageRenderer imgr = null;
        private InputStream is;

        private EMFHandler() {
        }

        @Override
        public void parse(File file) throws IOException {
            this.imgr = DrawPictureShape.getImageRenderer(null, (String)this.getContentType());
            if (this.imgr instanceof BitmapImageRenderer) {
                throw new NoScratchpadException();
            }
            this.is = file.toURI().toURL().openStream();
            this.imgr.loadImage(this.is, this.getContentType());
        }

        protected String getContentType() {
            return PictureData.PictureType.EMF.contentType;
        }

        @Override
        public Dimension2D getSize() {
            return this.imgr.getDimension();
        }

        @Override
        public String getTitle() {
            return "";
        }

        @Override
        public void draw(Graphics2D ctx) {
            Dimension2D dim = this.getSize();
            this.imgr.drawImage(ctx, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, dim.getWidth(), dim.getHeight()));
        }

        @Override
        public void close() throws IOException {
            if (this.is != null) {
                try {
                    this.is.close();
                }
                finally {
                    this.is = null;
                }
            }
        }

        @Override
        public GenericRecord getRoot() {
            return this.imgr.getGenericRecord();
        }
    }

    private static interface MFProxy
    extends Closeable {
        public void parse(File var1) throws IOException;

        public Dimension2D getSize();

        default public void setSlideNo(int slideNo) {
        }

        public String getTitle();

        public void draw(Graphics2D var1);

        default public int getSlideCount() {
            return 1;
        }

        default public Set<Integer> slideIndexes(String range) {
            return Collections.singleton(1);
        }

        public GenericRecord getRoot();
    }

    private static class NoScratchpadException
    extends IOException {
        public NoScratchpadException() {
        }

        public NoScratchpadException(Throwable cause) {
            super(cause);
        }
    }

    private static class PPTHandler
    implements MFProxy {
        SlideShow<?, ?> ppt;
        Slide<?, ?> slide;
        private static final String RANGE_PATTERN = "(^|,)(?<from>\\d+)?(-(?<to>\\d+))?";

        private PPTHandler() {
        }

        @Override
        public void parse(File file) throws IOException {
            try {
                this.ppt = SlideShowFactory.create((File)file, null, (boolean)true);
            }
            catch (IOException e) {
                if (e.getMessage().contains("scratchpad")) {
                    throw new NoScratchpadException(e);
                }
                throw e;
            }
            this.slide = (Slide)this.ppt.getSlides().get(0);
        }

        @Override
        public Dimension2D getSize() {
            return this.ppt.getPageSize();
        }

        @Override
        public int getSlideCount() {
            return this.ppt.getSlides().size();
        }

        @Override
        public void setSlideNo(int slideNo) {
            this.slide = (Slide)this.ppt.getSlides().get(slideNo - 1);
        }

        @Override
        public String getTitle() {
            return this.slide.getTitle();
        }

        @Override
        public Set<Integer> slideIndexes(String range) {
            final Matcher matcher = Pattern.compile(RANGE_PATTERN).matcher(range);
            Spliterators.AbstractSpliterator<Matcher> sp = new Spliterators.AbstractSpliterator<Matcher>((long)range.length(), 272){

                @Override
                public boolean tryAdvance(Consumer<? super Matcher> action) {
                    boolean b = matcher.find();
                    if (b) {
                        action.accept(matcher);
                    }
                    return b;
                }
            };
            return StreamSupport.stream(sp, false).flatMap(this::range).collect(Collectors.toCollection(TreeSet::new));
        }

        @Override
        public void draw(Graphics2D ctx) {
            this.slide.draw(ctx);
        }

        @Override
        public void close() throws IOException {
            if (this.ppt != null) {
                this.ppt.close();
            }
        }

        @Override
        public GenericRecord getRoot() {
            return this.ppt instanceof GenericRecord ? (GenericRecord)this.ppt : null;
        }

        private Stream<Integer> range(Matcher m) {
            int from;
            int slideCount = this.ppt.getSlides().size();
            String fromStr = m.group("from");
            String toStr = m.group("to");
            int n = from = fromStr == null || fromStr.isEmpty() ? 1 : Integer.parseInt(fromStr);
            int to = toStr == null ? from : (toStr.isEmpty() || (fromStr == null || fromStr.isEmpty()) && "1".equals(toStr) ? slideCount : Integer.parseInt(toStr));
            return IntStream.rangeClosed(from, to).filter(i -> i <= slideCount).boxed();
        }
    }

    private static class WMFHandler
    extends EMFHandler {
        private WMFHandler() {
        }

        @Override
        protected String getContentType() {
            return PictureData.PictureType.WMF.contentType;
        }
    }
}

