/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.resources;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.constants.Severity;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.resources.ThemeEngine;

public final class StatusDisplayInfo {
    private static final String[] STATUS_COLOR_NAMES = new String[]{"Status.Normal", "Status.Warning", "Status.Minor", "Status.Major", "Status.Critical", "Status.Unknown", "Status.Unmanaged", "Status.Disabled", "Status.Testing"};
    private static String[] statusText = new String[9];
    private static ImageDescriptor[] statusImageDesc = new ImageDescriptor[9];
    private static Image[] statusImage = new Image[9];

    public static void init(Display display) {
        int n = ObjectStatus.NORMAL.getValue();
        Messages.get();
        StatusDisplayInfo.statusText[n] = Messages.StatusDisplayInfo_Normal;
        int n2 = ObjectStatus.WARNING.getValue();
        Messages.get();
        StatusDisplayInfo.statusText[n2] = Messages.StatusDisplayInfo_Warning;
        int n3 = ObjectStatus.MINOR.getValue();
        Messages.get();
        StatusDisplayInfo.statusText[n3] = Messages.StatusDisplayInfo_Minor;
        int n4 = ObjectStatus.MAJOR.getValue();
        Messages.get();
        StatusDisplayInfo.statusText[n4] = Messages.StatusDisplayInfo_Major;
        int n5 = ObjectStatus.CRITICAL.getValue();
        Messages.get();
        StatusDisplayInfo.statusText[n5] = Messages.StatusDisplayInfo_Critical;
        int n6 = ObjectStatus.UNKNOWN.getValue();
        Messages.get();
        StatusDisplayInfo.statusText[n6] = Messages.StatusDisplayInfo_Unknown;
        int n7 = ObjectStatus.UNMANAGED.getValue();
        Messages.get();
        StatusDisplayInfo.statusText[n7] = Messages.StatusDisplayInfo_Unmanaged;
        int n8 = ObjectStatus.DISABLED.getValue();
        Messages.get();
        StatusDisplayInfo.statusText[n8] = Messages.StatusDisplayInfo_Disabled;
        int n9 = ObjectStatus.TESTING.getValue();
        Messages.get();
        StatusDisplayInfo.statusText[n9] = Messages.StatusDisplayInfo_Testing;
        StatusDisplayInfo.statusImageDesc[ObjectStatus.NORMAL.getValue()] = Activator.getImageDescriptor("icons/status/normal.png");
        StatusDisplayInfo.statusImageDesc[ObjectStatus.WARNING.getValue()] = Activator.getImageDescriptor("icons/status/warning.png");
        StatusDisplayInfo.statusImageDesc[ObjectStatus.MINOR.getValue()] = Activator.getImageDescriptor("icons/status/minor.png");
        StatusDisplayInfo.statusImageDesc[ObjectStatus.MAJOR.getValue()] = Activator.getImageDescriptor("icons/status/major.png");
        StatusDisplayInfo.statusImageDesc[ObjectStatus.CRITICAL.getValue()] = Activator.getImageDescriptor("icons/status/critical.png");
        StatusDisplayInfo.statusImageDesc[ObjectStatus.UNKNOWN.getValue()] = Activator.getImageDescriptor("icons/status/unknown.png");
        StatusDisplayInfo.statusImageDesc[ObjectStatus.UNMANAGED.getValue()] = Activator.getImageDescriptor("icons/status/unmanaged.png");
        StatusDisplayInfo.statusImageDesc[ObjectStatus.DISABLED.getValue()] = Activator.getImageDescriptor("icons/status/disabled.png");
        StatusDisplayInfo.statusImageDesc[ObjectStatus.TESTING.getValue()] = Activator.getImageDescriptor("icons/status/testing.png");
        int i = 0;
        while (i < statusImageDesc.length) {
            StatusDisplayInfo.statusImage[i] = statusImageDesc[i].createImage();
            ++i;
        }
    }

    public static String getStatusText(ObjectStatus status) {
        return statusText[status.getValue()];
    }

    public static String getStatusText(Severity severity) {
        return statusText[severity.getValue()];
    }

    public static String getStatusText(int code) {
        return StatusDisplayInfo.getStatusText(ObjectStatus.getByValue((int)code));
    }

    public static ImageDescriptor getStatusImageDescriptor(ObjectStatus status) {
        return statusImageDesc[status.getValue()];
    }

    public static ImageDescriptor getStatusImageDescriptor(Severity severity) {
        return statusImageDesc[severity.getValue()];
    }

    public static ImageDescriptor getStatusImageDescriptor(int code) {
        return StatusDisplayInfo.getStatusImageDescriptor(ObjectStatus.getByValue((int)code));
    }

    public static Image getStatusImage(ObjectStatus status) {
        return statusImage[status.getValue()];
    }

    public static Image getStatusImage(int code) {
        return StatusDisplayInfo.getStatusImage(ObjectStatus.getByValue((int)code));
    }

    public static Image getStatusImage(Severity severity) {
        return statusImage[severity.getValue()];
    }

    public static Color getStatusColor(ObjectStatus status) {
        return ThemeEngine.getForegroundColor(STATUS_COLOR_NAMES[status.getValue()]);
    }

    public static Color getStatusColor(Severity severity) {
        return ThemeEngine.getForegroundColor(STATUS_COLOR_NAMES[severity.getValue()]);
    }

    public static Color getStatusColor(int code) {
        return StatusDisplayInfo.getStatusColor(ObjectStatus.getByValue((int)code));
    }
}

