/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.internal.dialogs.FilteredPreferenceDialog;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.objects.Node;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpObjectIdFormatException;
import org.netxms.ui.eclipse.console.resources.DataCollectionDisplayInfo;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.IParameterSelectionDialog;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectAgentParamDlg;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectInternalParamDlg;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectParameterScriptDialog;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectSnmpParamDlg;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectWebServiceDlg;
import org.netxms.ui.eclipse.datacollection.dialogs.WinPerfCounterSelectionDialog;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.AbstractDCIPropertyPage;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.AbstractSelector;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class General
extends AbstractDCIPropertyPage {
    public static final String[] DATA_UNITS = new String[]{"%", "\u00c2\u00b0C", "\u00c2\u00b0F", "A", "B (IEC)", "b (IEC)", "B (Metric)", "b (Metric)", "B/s", "b/s", "dBm", "Epoch time", "Hz", "J", "lm", "lx", "N", "Pa", "rpm", "s", "T", "Uptime", "W", "V", "\u00ce\u00a9"};
    private static final int SUB_ELEMENT_INDENT = 20;
    private DataCollectionObject dco;
    private Combo origin;
    private MetricSelector metricSelector;
    private LabeledText description;
    private ObjectSelector sourceNode;
    private Combo dataType;
    private Combo useMultipliers;
    private Combo dataUnit;
    private Button scheduleDefault;
    private Button scheduleFixed;
    private Button scheduleAdvanced;
    private Composite pollingIntervalComposite;
    private Label pollingIntervalLabel;
    private Hyperlink scheduleLink;
    private Button storageDefault;
    private Button storageFixed;
    private Button storageNoStorage;
    private Composite retentionTimeComposite;
    private Text pollingInterval;
    private Text retentionTime;
    private Button checkSaveOnlyChangedValues;
    private static final DataType[] TYPES = new DataType[]{DataType.INT32, DataType.UINT32, DataType.COUNTER32, DataType.INT64, DataType.UINT64, DataType.COUNTER64, DataType.FLOAT, DataType.STRING};

    @Override
    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dco = this.editor.getObject();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginRight = 4;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Group groupMetricConfig = new Group(dialogArea, 0);
        groupMetricConfig.setText("Metric to collect");
        layout = new GridLayout();
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        layout.numColumns = 2;
        groupMetricConfig.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        groupMetricConfig.setLayoutData((Object)gd);
        Messages.get();
        this.origin = WidgetHelper.createLabeledCombo((Composite)groupMetricConfig, (int)8, (String)Messages.General_Origin, (Object)new GridData());
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceInternal);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceAgent);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceSNMP);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceWebService);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourcePush);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceWinPerf);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceILO);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceScript);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceSSH);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceMQTT);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceDeviceDriver);
        this.origin.add("Modbus");
        this.origin.select(this.dco.getOrigin().getValue());
        this.origin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                General.this.onOriginChange();
            }
        });
        this.sourceNode = new ObjectSelector((Composite)groupMetricConfig, 0, true);
        this.sourceNode.setLabel("Source node override");
        this.sourceNode.setObjectClass(Node.class);
        this.sourceNode.setObjectId(this.dco.getSourceNode());
        this.sourceNode.setEnabled(this.dco.getOrigin() != DataOrigin.PUSH);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.sourceNode.setLayoutData((Object)gd);
        this.metricSelector = new MetricSelector((Composite)groupMetricConfig);
        this.metricSelector.setMetricName(this.dco.getName());
        this.metricSelector.setLabel("Metric");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.metricSelector.setLayoutData(gd);
        this.description = new LabeledText((Composite)groupMetricConfig, 0);
        this.description.setLabel("Display name");
        this.description.getTextControl().setTextLimit(255);
        this.description.setText(this.dco.getDescription());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.description.setLayoutData((Object)gd);
        if (this.dco instanceof DataCollectionItem) {
            DataCollectionItem dci = (DataCollectionItem)this.dco;
            Group groupProcessingAndVisualization = new Group(dialogArea, 0);
            Messages.get();
            groupProcessingAndVisualization.setText(Messages.General_Polling);
            layout = new GridLayout();
            layout.marginHeight = 4;
            layout.marginWidth = 4;
            layout.numColumns = 3;
            groupProcessingAndVisualization.setLayout((Layout)layout);
            gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 4;
            groupProcessingAndVisualization.setLayoutData((Object)gd);
            gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            Messages.get();
            this.dataType = WidgetHelper.createLabeledCombo((Composite)groupProcessingAndVisualization, (int)8, (String)Messages.General_DataType, (Object)gd);
            this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.INT32));
            this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.UINT32));
            this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.COUNTER32));
            this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.INT64));
            this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.UINT64));
            this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.COUNTER64));
            this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.FLOAT));
            this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.STRING));
            this.dataType.select(General.getDataTypePosition(dci.getDataType()));
            gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            this.dataUnit = WidgetHelper.createLabeledCombo((Composite)groupProcessingAndVisualization, (int)0, (String)"Units", (Object)gd);
            int selection = -1;
            int index = 0;
            while (index < DATA_UNITS.length) {
                this.dataUnit.add(DATA_UNITS[index]);
                if (dci.getUnitName() != null && dci.getUnitName().equals(DATA_UNITS[index])) {
                    selection = index;
                }
                ++index;
            }
            if (selection == -1 && dci.getUnitName() != null) {
                this.dataUnit.add(dci.getUnitName());
                selection = index;
            }
            this.dataUnit.select(selection);
            this.useMultipliers = WidgetHelper.createLabeledCombo((Composite)groupProcessingAndVisualization, (int)8, (String)"Use multipliers", (Object)new GridData());
            this.useMultipliers.add("Default");
            this.useMultipliers.add("Yes");
            this.useMultipliers.add("No");
            this.useMultipliers.select(dci.getMultipliersSelection());
        }
        Group groupPolling = new Group(dialogArea, 0);
        groupPolling.setText("Collection schedule");
        layout = new GridLayout();
        layout.marginTop = 4;
        layout.marginBottom = 8;
        layout.marginWidth = 4;
        layout.numColumns = 2;
        groupPolling.setLayout((Layout)layout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        groupPolling.setLayoutData((Object)gd);
        SelectionAdapter pollingButtons = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                General.this.pollingInterval.setEnabled(General.this.scheduleFixed.getSelection());
                if (General.this.scheduleFixed.getSelection()) {
                    General.this.pollingInterval.setFocus();
                }
                General.this.pollingIntervalComposite.setVisible(General.this.scheduleFixed.getSelection());
                General.this.scheduleLink.setVisible(General.this.scheduleAdvanced.getSelection());
            }
        };
        NXCSession session = ConsoleSharedData.getSession();
        this.scheduleDefault = new Button((Composite)groupPolling, 16);
        this.scheduleDefault.setText(String.format("Server default interval (%d seconds)", session.getDefaultDciPollingInterval()));
        this.scheduleDefault.setSelection(this.dco.getPollingScheduleType() == 0);
        this.scheduleDefault.addSelectionListener((SelectionListener)pollingButtons);
        gd = new GridData(16384, 0x1000000, false, false);
        gd.horizontalSpan = 2;
        this.scheduleDefault.setLayoutData((Object)gd);
        this.scheduleFixed = new Button((Composite)groupPolling, 16);
        this.scheduleFixed.setText("Custom interval");
        this.scheduleFixed.setSelection(this.dco.getPollingScheduleType() == 1);
        this.scheduleFixed.addSelectionListener((SelectionListener)pollingButtons);
        this.scheduleFixed.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.pollingIntervalComposite = new Composite((Composite)groupPolling, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 2;
        layout.numColumns = 2;
        this.pollingIntervalComposite.setLayout((Layout)layout);
        this.pollingInterval = new Text(this.pollingIntervalComposite, 2048);
        this.pollingInterval.setText(this.dco.getPollingInterval() != null ? this.dco.getPollingInterval() : "");
        this.pollingInterval.setEnabled(this.dco.getPollingScheduleType() == 1 && this.dco.getOrigin() != DataOrigin.PUSH);
        gd = new GridData(4, 0x1000000, true, false);
        this.pollingInterval.setLayoutData((Object)gd);
        this.pollingIntervalLabel = new Label(this.pollingIntervalComposite, 0);
        this.pollingIntervalLabel.setText("seconds");
        gd = new GridData(16384, 0x1000000, false, false);
        gd.horizontalIndent = 4;
        this.pollingIntervalLabel.setLayoutData((Object)gd);
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalIndent = 20;
        this.pollingIntervalComposite.setLayoutData((Object)gd);
        this.scheduleAdvanced = new Button((Composite)groupPolling, 16);
        this.scheduleAdvanced.setText("Advanced schedule");
        this.scheduleAdvanced.setSelection(this.dco.getPollingScheduleType() == 2);
        this.scheduleAdvanced.addSelectionListener((SelectionListener)pollingButtons);
        this.scheduleAdvanced.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.scheduleLink = new Hyperlink((Composite)groupPolling, 0);
        this.scheduleLink.setText("Configure");
        this.scheduleLink.setUnderlined(true);
        this.scheduleLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IPreferencePageContainer container = General.this.getContainer();
                FilteredPreferenceDialog dialog = (FilteredPreferenceDialog)container;
                dialog.setCurrentPageId("org.netxms.ui.eclipse.datacollection.propertypages.CustomSchedule#10");
            }
        });
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalIndent = 20;
        this.scheduleLink.setLayoutData((Object)gd);
        this.pollingIntervalComposite.setVisible(this.scheduleFixed.getSelection());
        this.scheduleLink.setVisible(this.scheduleAdvanced.getSelection());
        Group groupRetention = new Group(dialogArea, 0);
        groupRetention.setText("History retention period");
        layout = new GridLayout();
        layout.marginTop = 4;
        layout.marginBottom = 8;
        layout.marginWidth = 4;
        layout.numColumns = 2;
        groupRetention.setLayout((Layout)layout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        groupRetention.setLayoutData((Object)gd);
        SelectionAdapter storageButtons = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                General.this.retentionTime.setEnabled(General.this.storageFixed.getSelection());
                if (General.this.storageFixed.getSelection()) {
                    General.this.retentionTime.setFocus();
                }
                General.this.retentionTimeComposite.setVisible(General.this.storageFixed.getSelection());
            }
        };
        this.storageDefault = new Button((Composite)groupRetention, 16);
        this.storageDefault.setText(String.format("Server default (%d days)", session.getDefaultDciRetentionTime()));
        this.storageDefault.setSelection(this.dco.getRetentionType() == 0);
        this.storageDefault.addSelectionListener((SelectionListener)storageButtons);
        gd = new GridData(16384, 0x1000000, false, false);
        gd.horizontalSpan = 2;
        this.storageDefault.setLayoutData((Object)gd);
        this.storageFixed = new Button((Composite)groupRetention, 16);
        this.storageFixed.setText("Custom");
        this.storageFixed.setSelection(this.dco.getRetentionType() == 1);
        this.storageFixed.addSelectionListener((SelectionListener)storageButtons);
        this.retentionTimeComposite = new Composite((Composite)groupRetention, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 2;
        layout.numColumns = 2;
        this.retentionTimeComposite.setLayout((Layout)layout);
        this.retentionTime = new Text(this.retentionTimeComposite, 2048);
        this.retentionTime.setText(this.dco.getRetentionTime() != null ? this.dco.getRetentionTime() : "");
        this.retentionTime.setEnabled(this.dco.getRetentionType() == 1);
        gd = new GridData(4, 0x1000000, true, false);
        this.retentionTime.setLayoutData((Object)gd);
        Label label = new Label(this.retentionTimeComposite, 0);
        label.setText("days");
        gd = new GridData(16384, 0x1000000, false, false);
        gd.horizontalIndent = 4;
        label.setLayoutData((Object)gd);
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalIndent = 20;
        this.retentionTimeComposite.setLayoutData((Object)gd);
        this.storageNoStorage = new Button((Composite)groupRetention, 16);
        this.storageNoStorage.setText("Do not save to the database");
        this.storageNoStorage.setSelection(this.dco.getRetentionType() == 2);
        this.storageNoStorage.addSelectionListener((SelectionListener)storageButtons);
        this.retentionTimeComposite.setVisible(this.storageFixed.getSelection());
        if (this.dco instanceof DataCollectionItem) {
            DataCollectionItem dci = (DataCollectionItem)this.dco;
            this.checkSaveOnlyChangedValues = new Button((Composite)groupRetention, 32);
            this.checkSaveOnlyChangedValues.setText("Save only &changed values");
            this.checkSaveOnlyChangedValues.setSelection(dci.isStoreChangesOnly());
            gd = new GridData();
            gd.horizontalSpan = 2;
            gd.verticalIndent = 20;
            this.checkSaveOnlyChangedValues.setLayoutData((Object)gd);
        }
        this.onOriginChange();
        return dialogArea;
    }

    private void onOriginChange() {
        DataOrigin dataOrigin = DataOrigin.getByValue((int)this.origin.getSelectionIndex());
        this.sourceNode.setEnabled(dataOrigin != DataOrigin.PUSH);
        boolean enableSchedule = dataOrigin != DataOrigin.PUSH;
        this.scheduleDefault.setEnabled(enableSchedule);
        this.scheduleFixed.setEnabled(enableSchedule);
        this.scheduleAdvanced.setEnabled(enableSchedule);
        this.pollingInterval.setEnabled(enableSchedule);
        this.pollingIntervalLabel.setEnabled(enableSchedule);
        this.scheduleLink.setEnabled(enableSchedule);
        this.metricSelector.setSelectioEnabled(dataOrigin == DataOrigin.AGENT || dataOrigin == DataOrigin.SNMP || dataOrigin == DataOrigin.INTERNAL || dataOrigin == DataOrigin.WINPERF || dataOrigin == DataOrigin.WEB_SERVICE || dataOrigin == DataOrigin.DEVICE_DRIVER || dataOrigin == DataOrigin.SCRIPT);
    }

    protected boolean applyChanges(boolean isApply) {
        this.dco.setOrigin(DataOrigin.getByValue((int)this.origin.getSelectionIndex()));
        this.dco.setName(this.metricSelector.getMetricName().trim());
        this.dco.setDescription(this.description.getText().trim());
        this.dco.setSourceNode(this.sourceNode.getObjectId());
        this.dco.setPollingScheduleType(this.getScheduleType());
        this.dco.setPollingInterval(this.scheduleFixed.getSelection() ? this.pollingInterval.getText() : null);
        this.dco.setRetentionType(this.getRetentionType());
        this.dco.setRetentionTime(this.storageFixed.getSelection() ? this.retentionTime.getText() : null);
        if (this.dco instanceof DataCollectionItem) {
            DataCollectionItem dci = (DataCollectionItem)this.dco;
            dci.setDataType(General.getDataTypeByPosition(this.dataType.getSelectionIndex()));
            dci.setUnitName(this.dataUnit.getText());
            dci.setMultiplierSelection(this.useMultipliers.getSelectionIndex());
            dci.setStoreChangesOnly(this.checkSaveOnlyChangedValues.getSelection());
        }
        this.editor.modify();
        return true;
    }

    private int getScheduleType() {
        int type = 0;
        if (this.scheduleFixed.getSelection()) {
            type = 1;
        } else if (this.scheduleAdvanced.getSelection()) {
            type = 2;
        }
        return type;
    }

    private int getRetentionType() {
        int type = 0;
        if (this.storageFixed.getSelection()) {
            type = 1;
        } else if (this.storageNoStorage.getSelection()) {
            type = 2;
        }
        return type;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        NXCSession session = ConsoleSharedData.getSession();
        this.scheduleDefault.setSelection(true);
        this.scheduleFixed.setSelection(false);
        this.scheduleAdvanced.setSelection(false);
        this.pollingInterval.setText(Integer.toString(session.getDefaultDciPollingInterval()));
        this.storageDefault.setSelection(true);
        this.storageFixed.setSelection(false);
        this.storageNoStorage.setSelection(false);
        this.retentionTime.setText(Integer.toString(session.getDefaultDciRetentionTime()));
        this.useMultipliers.select(0);
    }

    private static int getDataTypePosition(DataType type) {
        switch (type) {
            case COUNTER32: {
                return 2;
            }
            case COUNTER64: {
                return 5;
            }
            case FLOAT: {
                return 6;
            }
            case INT32: {
                return 0;
            }
            case INT64: {
                return 3;
            }
            case STRING: {
                return 7;
            }
            case UINT32: {
                return 1;
            }
            case UINT64: {
                return 4;
            }
        }
        return 0;
    }

    private static DataType getDataTypeByPosition(int position) {
        return TYPES[position];
    }

    private class MetricSelector
    extends AbstractSelector {
        public MetricSelector(Composite parent) {
            super(parent, 0, 16);
        }

        protected void selectionButtonHandler() {
            IParameterSelectionDialog dlg = null;
            DataOrigin dataOrigin = DataOrigin.getByValue((int)General.this.origin.getSelectionIndex());
            boolean isTable = General.this.dco instanceof DataCollectionTable;
            switch (dataOrigin) {
                case INTERNAL: {
                    if (General.this.sourceNode.getObjectId() != 0L) {
                        dlg = new SelectInternalParamDlg(this.getShell(), General.this.sourceNode.getObjectId(), isTable);
                        break;
                    }
                    dlg = new SelectInternalParamDlg(this.getShell(), General.this.dco.getNodeId(), isTable);
                    break;
                }
                case AGENT: 
                case DEVICE_DRIVER: {
                    if (General.this.sourceNode.getObjectId() != 0L) {
                        dlg = new SelectAgentParamDlg(this.getShell(), General.this.sourceNode.getObjectId(), dataOrigin, isTable);
                        break;
                    }
                    dlg = new SelectAgentParamDlg(this.getShell(), General.this.dco.getNodeId(), dataOrigin, isTable);
                    break;
                }
                case SNMP: {
                    SnmpObjectId oid;
                    try {
                        oid = SnmpObjectId.parseSnmpObjectId((String)General.this.metricSelector.getText());
                    }
                    catch (SnmpObjectIdFormatException e) {
                        oid = null;
                    }
                    if (General.this.sourceNode.getObjectId() != 0L) {
                        dlg = new SelectSnmpParamDlg(this.getShell(), oid, General.this.sourceNode.getObjectId());
                        break;
                    }
                    dlg = new SelectSnmpParamDlg(this.getShell(), oid, General.this.dco.getNodeId());
                    break;
                }
                case WINPERF: {
                    if (isTable) break;
                    if (General.this.sourceNode.getObjectId() != 0L) {
                        dlg = new WinPerfCounterSelectionDialog(this.getShell(), General.this.sourceNode.getObjectId());
                        break;
                    }
                    dlg = new WinPerfCounterSelectionDialog(this.getShell(), General.this.dco.getNodeId());
                    break;
                }
                case SCRIPT: {
                    dlg = new SelectParameterScriptDialog(this.getShell());
                    break;
                }
                case WEB_SERVICE: {
                    if (isTable) break;
                    dlg = new SelectWebServiceDlg(this.getShell(), false);
                    break;
                }
                default: {
                    dlg = null;
                }
            }
            if (dlg != null && dlg.open() == 0) {
                IParameterSelectionDialog pd = dlg;
                General.this.description.setText(pd.getParameterDescription());
                General.this.metricSelector.setText(pd.getParameterName());
                General.this.dataType.select(General.getDataTypePosition(pd.getParameterDataType()));
                General.this.editor.fireOnSelectItemListeners(DataOrigin.getByValue((int)General.this.origin.getSelectionIndex()), pd.getParameterName(), pd.getParameterDescription(), pd.getParameterDataType());
            }
        }

        public void setMetricName(String name) {
            this.setText(name);
        }

        public String getMetricName() {
            return this.getText();
        }
    }
}

