/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AMSystemType {
    NONE(0),
    SERIAL(1),
    IP_ADDRESS(2),
    MAC_ADDRESS(3),
    VENDOR(4),
    MODEL(5);

    private static Logger logger;
    private static Map<Integer, AMSystemType> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(AMSystemType.class);
        lookupTable = new HashMap<Integer, AMSystemType>();
        AMSystemType[] aMSystemTypeArray = AMSystemType.values();
        int n = aMSystemTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AMSystemType element = aMSystemTypeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private AMSystemType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AMSystemType getByValue(int value) {
        AMSystemType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return NONE;
        }
        return element;
    }
}

