/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DataOrigin {
    INTERNAL(0),
    AGENT(1),
    SNMP(2),
    WEB_SERVICE(3),
    PUSH(4),
    WINPERF(5),
    SMCLP(6),
    SCRIPT(7),
    SSH(8),
    MQTT(9),
    DEVICE_DRIVER(10),
    MODBUS(11);

    private static Logger logger;
    private static Map<Integer, DataOrigin> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(DataOrigin.class);
        lookupTable = new HashMap<Integer, DataOrigin>();
        DataOrigin[] dataOriginArray = DataOrigin.values();
        int n = dataOriginArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataOrigin element = dataOriginArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private DataOrigin(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static DataOrigin getByValue(int value) {
        DataOrigin element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return INTERNAL;
        }
        return element;
    }
}

