/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.concurrent.CountDownLatch;
import org.netxms.base.NXCPMessage;

public abstract class MessageHandler {
    private CountDownLatch latch = new CountDownLatch(1);
    private boolean expired = false;
    private long lastMessageTimestamp = System.currentTimeMillis();
    private int messageWaitTimeout = 60000;

    protected final void setComplete() {
        this.latch.countDown();
    }

    public final boolean isComplete() {
        return this.latch.getCount() == 0L;
    }

    public final void waitForCompletion() {
        boolean done = false;
        do {
            try {
                this.latch.await();
                done = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!done);
    }

    protected long getLastMessageTimestamp() {
        return this.lastMessageTimestamp;
    }

    protected void setLastMessageTimestamp(long lastMessageTimestamp) {
        this.lastMessageTimestamp = lastMessageTimestamp;
    }

    public boolean isExpired() {
        return this.expired;
    }

    protected void setExpired() {
        this.expired = true;
        this.setComplete();
    }

    public int getMessageWaitTimeout() {
        return this.messageWaitTimeout;
    }

    public void setMessageWaitTimeout(int messageWaitTimeout) {
        this.messageWaitTimeout = messageWaitTimeout;
    }

    public abstract boolean processMessage(NXCPMessage var1);
}

