/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.net.InetAddress;
import java.util.Date;
import org.netxms.base.NXCPMessage;

public class UserSession {
    private int id;
    private String loginName;
    private String terminal;
    private boolean connected;
    private String clientName;
    private InetAddress clientAddress;
    private int displayWidth;
    private int displayHeight;
    private int displayColorDepth;
    private Date connectTime;
    private Date loginTime;
    private int idleTime;
    private long agentPID;
    private int agentType;

    protected UserSession(NXCPMessage msg, long baseId) {
        this.id = msg.getFieldAsInt32(baseId);
        this.loginName = msg.getFieldAsString(baseId + 1L);
        this.terminal = msg.getFieldAsString(baseId + 2L);
        this.connected = msg.getFieldAsBoolean(baseId + 3L);
        this.clientName = msg.getFieldAsString(baseId + 4L);
        this.clientAddress = msg.getFieldAsInetAddress(baseId + 5L);
        this.displayWidth = msg.getFieldAsInt32(baseId + 6L);
        this.displayHeight = msg.getFieldAsInt32(baseId + 7L);
        this.displayColorDepth = msg.getFieldAsInt32(baseId + 8L);
        this.connectTime = msg.getFieldAsDate(baseId + 9L);
        this.loginTime = msg.getFieldAsDate(baseId + 10L);
        this.idleTime = msg.getFieldAsInt32(baseId + 11L);
        this.agentPID = msg.getFieldAsInt64(baseId + 12L);
        this.agentType = msg.getFieldAsInt32(baseId + 13L);
    }

    public int getId() {
        return this.id;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public String getTerminal() {
        return this.terminal;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getClientName() {
        return this.clientName;
    }

    public InetAddress getClientAddress() {
        return this.clientAddress;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    public int getDisplayColorDepth() {
        return this.displayColorDepth;
    }

    public String getDisplayDescription() {
        if (this.displayHeight <= 0 || this.displayWidth <= 0 || this.displayColorDepth <= 0) {
            return "";
        }
        return String.valueOf(this.displayWidth) + "x" + this.displayHeight + "x" + this.displayColorDepth;
    }

    public Date getConnectTime() {
        return this.connectTime;
    }

    public Date getLoginTime() {
        return this.loginTime;
    }

    public int getIdleTime() {
        return this.idleTime;
    }

    public long getAgentPID() {
        return this.agentPID;
    }

    public int getAgentType() {
        return this.agentType;
    }
}

