/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.services;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.netxms.client.ModuleDataProvider;
import org.netxms.client.services.ServiceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceManager {
    private static final Logger logger = LoggerFactory.getLogger(ServiceManager.class);
    private static final Map<ClassLoader, ServiceLoader<ServiceHandler>> serviceLoaders = new HashMap<ClassLoader, ServiceLoader<ServiceHandler>>();
    private static final Map<String, ModuleDataProvider> dataProviders = new HashMap<String, ModuleDataProvider>();
    private static final Set<String> missingDataProviders = new HashSet<String>();

    public static synchronized void registerClassLoader(ClassLoader classLoader) {
        ServiceLoader<ServiceHandler> serviceLoader = serviceLoaders.get(classLoader);
        if (serviceLoader != null) {
            serviceLoader.reload();
        } else {
            serviceLoaders.put(classLoader, ServiceLoader.load(ServiceHandler.class, classLoader));
        }
    }

    public static synchronized ModuleDataProvider getModuleDataProvider(String name) {
        if (missingDataProviders.contains(name)) {
            return null;
        }
        ModuleDataProvider p = dataProviders.get(name);
        if (p != null) {
            return p;
        }
        for (ServiceLoader<ServiceHandler> loader : serviceLoaders.values()) {
            for (ServiceHandler s : loader) {
                if (!s.getServiceName().equals(name) || !(s instanceof ModuleDataProvider)) continue;
                dataProviders.put(name, (ModuleDataProvider)s);
                return (ModuleDataProvider)s;
            }
        }
        logger.warn("Unable to find data provider for module " + name);
        missingDataProviders.add(name);
        return null;
    }

    public static synchronized ServiceHandler getServiceHandler(String name) {
        for (ServiceLoader<ServiceHandler> loader : serviceLoaders.values()) {
            for (ServiceHandler s : loader) {
                if (!s.getServiceName().equals(name)) continue;
                return s;
            }
        }
        return null;
    }

    public static synchronized ServiceHandler getServiceHandler(Class<? extends ServiceHandler> serviceClass) {
        for (ServiceLoader<ServiceHandler> loader : serviceLoaders.values()) {
            for (ServiceHandler s : loader) {
                if (!serviceClass.isInstance(s)) continue;
                return s;
            }
        }
        return null;
    }

    public static synchronized void dump() {
        for (ServiceLoader<ServiceHandler> loader : serviceLoaders.values()) {
            for (ServiceHandler s : loader) {
                System.out.println(s.getServiceName());
            }
        }
    }
}

