/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.topology;

import java.net.InetAddress;
import org.netxms.base.NXCPMessage;

public class HopInfo {
    public static final int ROUTE = 0;
    public static final int VPN = 1;
    public static final int PROXY = 2;
    public static final int DUMMY = 3;
    private long nodeId;
    private InetAddress nextHop;
    private int ifIndex;
    private int type;
    private String name;

    protected HopInfo(NXCPMessage msg, long baseId) {
        this.nodeId = msg.getFieldAsInt64(baseId);
        this.nextHop = msg.getFieldAsInetAddress(baseId + 1L);
        this.ifIndex = msg.getFieldAsInt32(baseId + 2L);
        this.type = msg.getFieldAsInt32(baseId + 3L);
        this.name = msg.getFieldAsString(baseId + 4L);
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public InetAddress getNextHop() {
        return this.nextHop;
    }

    public int getIfIndex() {
        return this.ifIndex;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name != null ? this.name : "";
    }
}

