/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import java.util.List;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.configs.SingleDciConfig;

public class LinkEditor {
    private NetworkMapLink link;
    private String name;
    private int type;
    private String connectorName1;
    private String connectorName2;
    private int color;
    private int colorSource;
    private String colorProvider;
    private List<Long> statusObjects;
    private int routingAlgorithm;
    private boolean modified = false;
    private List<SingleDciConfig> dciList;
    private boolean useActiveThresholds;

    public LinkEditor(NetworkMapLink link, NetworkMapPage mapPage) {
        this.link = link;
        this.name = link.getName();
        this.type = link.getType();
        this.connectorName1 = link.getConnectorName1();
        this.connectorName2 = link.getConnectorName2();
        this.color = link.getColor();
        this.colorSource = link.getColorSource();
        this.colorProvider = link.getColorProvider();
        this.statusObjects = link.getStatusObjects();
        this.routingAlgorithm = link.getRouting();
        this.dciList = link.getDciAsList();
        this.useActiveThresholds = link.getConfig().isUseActiveThresholds();
    }

    public boolean update(NetworkMapPage mapPage) {
        NetworkMapLink currentLink = null;
        for (NetworkMapLink l : mapPage.getLinks()) {
            if (l.getId() != this.link.getId()) continue;
            currentLink = l;
        }
        if (currentLink == null) {
            return false;
        }
        long[] bp = currentLink.getBendPoints();
        mapPage.removeLink(this.link.getId());
        this.link = new NetworkMapLink(this.link.getId(), this.name, this.type, currentLink.getElement1(), currentLink.getElement2(), this.connectorName1, this.connectorName2, this.dciList != null ? this.dciList.toArray(new SingleDciConfig[this.dciList.size()]) : new SingleDciConfig[]{}, currentLink.getFlags(), currentLink.isLocked());
        this.link.setColor(this.color);
        this.link.setColorSource(this.colorSource);
        this.link.setColorProvider(this.colorProvider);
        this.link.setStatusObjects(this.statusObjects);
        this.link.setRouting(this.routingAlgorithm);
        this.link.setBendPoints(bp);
        this.link.getConfig().setUseActiveThresholds(this.useActiveThresholds);
        mapPage.addLink(this.link);
        this.modified = true;
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getConnectorName1() {
        return this.connectorName1;
    }

    public void setConnectorName1(String connectorName1) {
        this.connectorName1 = connectorName1;
    }

    public String getConnectorName2() {
        return this.connectorName2;
    }

    public void setConnectorName2(String connectorName2) {
        this.connectorName2 = connectorName2;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getColorSource() {
        return this.colorSource;
    }

    public void setColorSource(int colorSource) {
        this.colorSource = colorSource;
    }

    public String getColorProvider() {
        return this.colorProvider;
    }

    public void setColorProvider(String colorProvider) {
        this.colorProvider = colorProvider;
    }

    public List<Long> getStatusObjects() {
        return this.statusObjects;
    }

    public void setStatusObjects(List<Long> statusObject) {
        this.statusObjects = statusObject;
    }

    public void addStatusObject(Long id) {
        this.statusObjects.add(id);
    }

    public void removeStatusObjectByIndex(int index) {
        this.statusObjects.remove(index);
    }

    public int getRoutingAlgorithm() {
        return this.routingAlgorithm;
    }

    public void setRoutingAlgorithm(int routingAlgorithm) {
        this.routingAlgorithm = routingAlgorithm;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified() {
        this.modified = true;
    }

    public List<SingleDciConfig> getDciList() {
        return this.dciList;
    }

    public void setDciList(List<SingleDciConfig> dciList) {
        this.dciList = dciList;
    }

    public boolean isUseActiveThresholds() {
        return this.useActiveThresholds;
    }

    public void setUseActiveThresholds(boolean useActiveThresholds) {
        this.useActiveThresholds = useActiveThresholds;
    }

    public NetworkMapLink getLink() {
        return this.link;
    }
}

