/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.gef4.zest.core.viewers.IGraphEntityRelationshipContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.maps.MapObjectDisplayMode;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapDCIContainer;
import org.netxms.client.maps.elements.NetworkMapDCIImage;
import org.netxms.client.maps.elements.NetworkMapDecoration;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.maps.elements.NetworkMapTextBox;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.networkmaps.Activator;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ExtendedGraphViewer;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class MapContentProvider
implements IGraphEntityRelationshipContentProvider {
    private ExtendedGraphViewer viewer;
    private NetworkMapPage page;
    private Map<Long, DciValue[]> cachedDciValues = new HashMap<Long, DciValue[]>();
    private NXCSession session = ConsoleSharedData.getSession();
    private Thread syncThread = null;
    private volatile boolean syncRunning = true;
    private MapLabelProvider labelProvider;

    public MapContentProvider(ExtendedGraphViewer viewer, MapLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
        this.viewer = viewer;
        final Display display = viewer.getControl().getDisplay();
        this.syncThread = new Thread(new Runnable(){

            @Override
            public void run() {
                MapContentProvider.this.syncData(display);
            }
        });
        this.syncThread.setDaemon(true);
        this.syncThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void syncData(Display display) {
        try {
            Thread.sleep(1000L);
            if (true) ** GOTO lbl29
        }
        catch (InterruptedException e) {
            return;
        }
        do {
            dataSyncSet = new HashSet<Long>();
            var3_4 = this.cachedDciValues;
            synchronized (var3_4) {
                if (this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.LARGE_LABEL && !this.cachedDciValues.isEmpty()) {
                    dataSyncSet.addAll(this.cachedDciValues.keySet());
                }
            }
            if (!dataSyncSet.isEmpty()) {
                try {
                    values = this.session.getTooltipLastValues(this.cachedDciValues.keySet());
                    display.asyncExec(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (MapContentProvider.this.viewer.getControl().isDisposed()) {
                                return;
                            }
                            Map<Long, DciValue[]> map = MapContentProvider.this.cachedDciValues;
                            synchronized (map) {
                                MapContentProvider.this.cachedDciValues.putAll(values);
                                if (MapContentProvider.this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.LARGE_LABEL) {
                                    for (Map.Entry<Long, DciValue[]> entry : MapContentProvider.this.cachedDciValues.entrySet()) {
                                        NetworkMapObject o;
                                        if (entry.getValue() == null || entry.getValue().length == 0 || (o = MapContentProvider.this.page.findObjectElement(entry.getKey().longValue())) == null) continue;
                                        MapContentProvider.this.viewer.refresh(o);
                                    }
                                }
                                if (MapContentProvider.this.page != null && MapContentProvider.this.page.getLinks() != null) {
                                    for (NetworkMapLink networkMapLink : MapContentProvider.this.page.getLinks()) {
                                        if (!networkMapLink.hasDciData()) continue;
                                        MapContentProvider.this.viewer.refresh(networkMapLink);
                                    }
                                }
                                if (MapContentProvider.this.page != null && MapContentProvider.this.page.getElements() != null) {
                                    for (NetworkMapElement networkMapElement : MapContentProvider.this.page.getElements()) {
                                        if ((!(networkMapElement instanceof NetworkMapDCIContainer) || !((NetworkMapDCIContainer)networkMapElement).hasDciData()) && !(networkMapElement instanceof NetworkMapDCIImage)) continue;
                                        MapContentProvider.this.viewer.updateDecorationFigure(networkMapElement);
                                    }
                                }
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Activator.logError("Exception in map data synchronization task", e);
                }
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                break;
            }
lbl29:
            // 2 sources

        } while (this.syncRunning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DciValue[] getNodeLastValues(long nodeId) {
        Map<Long, DciValue[]> map = this.cachedDciValues;
        synchronized (map) {
            return this.cachedDciValues.get(nodeId);
        }
    }

    public Object[] getElements(Object inputElement) {
        if (!(inputElement instanceof NetworkMapPage)) {
            return null;
        }
        ArrayList<NetworkMapElement> elements = new ArrayList<NetworkMapElement>(((NetworkMapPage)inputElement).getElements().size());
        for (NetworkMapElement e : ((NetworkMapPage)inputElement).getElements()) {
            if (e instanceof NetworkMapDecoration || e instanceof NetworkMapDCIContainer || e instanceof NetworkMapDCIImage || e instanceof NetworkMapTextBox) continue;
            elements.add(e);
        }
        return elements.toArray();
    }

    public Object[] getRelationships(Object source, Object dest) {
        return this.page.findLinks((NetworkMapElement)source, (NetworkMapElement)dest).toArray();
    }

    public void dispose() {
        this.syncRunning = false;
        this.syncThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Map<Long, DciValue[]> map = this.cachedDciValues;
        synchronized (map) {
            this.cachedDciValues.clear();
        }
        if (newInput instanceof NetworkMapPage) {
            this.page = (NetworkMapPage)newInput;
            map = this.cachedDciValues;
            synchronized (map) {
                for (NetworkMapElement e : this.page.getElements()) {
                    long id;
                    AbstractObject object;
                    if (!(e instanceof NetworkMapObject) || (object = this.session.findObjectById(id = ((NetworkMapObject)e).getObjectId())) == null || !(object instanceof AbstractNode)) continue;
                    this.cachedDciValues.put(id, null);
                }
            }
        } else {
            this.page = null;
        }
    }

    public List<NetworkMapElement> getDecorations(Object inputElement) {
        if (!(inputElement instanceof NetworkMapPage)) {
            return null;
        }
        ArrayList<NetworkMapElement> elements = new ArrayList<NetworkMapElement>(((NetworkMapPage)inputElement).getElements().size());
        for (NetworkMapElement e : ((NetworkMapPage)inputElement).getElements()) {
            if (!(e instanceof NetworkMapDecoration) && !(e instanceof NetworkMapDCIContainer) && !(e instanceof NetworkMapDCIImage) && !(e instanceof NetworkMapTextBox)) continue;
            elements.add(e);
        }
        return elements;
    }
}

