/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.epp.propertypages;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.ui.eclipse.console.dialogs.KeyValuePairEditDialog;
import org.netxms.ui.eclipse.epp.widgets.RuleEditor;
import org.netxms.ui.eclipse.tools.ElementLabelComparator;
import org.netxms.ui.eclipse.widgets.KeyValueSetEditor;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class RuleCustomAttribute
extends PropertyPage {
    private RuleEditor editor;
    private EventProcessingPolicyRule rule;
    private KeyValueSetEditor namesToSetEditor;
    private SortableTableViewer namesToDeleteViewer;
    private Button addToDeleteListButton;
    private Button editDeleteListButton;
    private Button removeFromDeleteListButton;
    private List<String> namesToDelete = new ArrayList<String>(0);

    protected Control createContents(Composite parent) {
        this.editor = (RuleEditor)((Object)this.getElement().getAdapter(RuleEditor.class));
        this.rule = this.editor.getRule();
        this.namesToDelete.addAll(this.rule.getCustomAttributeStorageDelete());
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        int vInd = 2;
        Label label = new Label(dialogArea, 0);
        label.setText("Set custom attribute values");
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        label.setLayoutData((Object)gd);
        this.namesToSetEditor = new KeyValueSetEditor(dialogArea, 0, "Name");
        this.namesToSetEditor.addAll(this.rule.getCustomAttributeStorageSet());
        gd = new GridData();
        gd.verticalIndent = 2;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.namesToSetEditor.setLayoutData((Object)gd);
        label = new Label(dialogArea, 0);
        label.setText("Delete custom attribute entries");
        gd = new GridData();
        gd.verticalIndent = 2;
        label.setLayoutData((Object)gd);
        String[] deleteColumnNames = new String[]{"Name"};
        int[] deleteColumnWidths = new int[]{150};
        this.namesToDeleteViewer = new SortableTableViewer(dialogArea, deleteColumnNames, deleteColumnWidths, 0, 128, 67586);
        this.namesToDeleteViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.namesToDeleteViewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)this.namesToDeleteViewer.getLabelProvider()));
        this.namesToDeleteViewer.setInput((Object)this.namesToDelete.toArray());
        this.namesToDeleteViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int size = RuleCustomAttribute.this.namesToDeleteViewer.getStructuredSelection().size();
                RuleCustomAttribute.this.editDeleteListButton.setEnabled(size == 1);
                RuleCustomAttribute.this.removeFromDeleteListButton.setEnabled(size > 0);
            }
        });
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.namesToDeleteViewer.getControl().setLayoutData((Object)gd);
        Composite buttonsDeleteValue = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonsDeleteValue.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttonsDeleteValue.setLayoutData((Object)gd);
        this.addToDeleteListButton = new Button(buttonsDeleteValue, 8);
        this.addToDeleteListButton.setText("Add");
        this.addToDeleteListButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuleCustomAttribute.this.addCustomAttributeDeleteAction();
            }
        });
        RowData rd = new RowData();
        rd.width = 90;
        this.addToDeleteListButton.setLayoutData((Object)rd);
        this.editDeleteListButton = new Button(buttonsDeleteValue, 8);
        this.editDeleteListButton.setText("Edit");
        this.editDeleteListButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuleCustomAttribute.this.editCustomAttributeDeleteAction();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.editDeleteListButton.setLayoutData((Object)rd);
        this.editDeleteListButton.setEnabled(false);
        this.removeFromDeleteListButton = new Button(buttonsDeleteValue, 8);
        this.removeFromDeleteListButton.setText("Delete");
        this.removeFromDeleteListButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuleCustomAttribute.this.deleteCustomAttributeDeleteAction();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.removeFromDeleteListButton.setLayoutData((Object)rd);
        this.removeFromDeleteListButton.setEnabled(false);
        return dialogArea;
    }

    private void addCustomAttributeDeleteAction() {
        KeyValuePairEditDialog dlg = new KeyValuePairEditDialog(this.getShell(), null, null, false, false, "Name");
        if (dlg.open() == 0) {
            this.namesToDelete.add(dlg.getAtributeName());
            this.namesToDeleteViewer.setInput((Object)this.namesToDelete.toArray());
        }
    }

    private void editCustomAttributeDeleteAction() {
        IStructuredSelection selection = this.namesToDeleteViewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        String attr = (String)selection.getFirstElement();
        KeyValuePairEditDialog dlg = new KeyValuePairEditDialog(this.getShell(), attr, null, false, false, "Name");
        if (dlg.open() == 0) {
            this.namesToDelete.set(this.namesToDelete.indexOf(attr), dlg.getAtributeName());
            this.namesToDeleteViewer.setInput((Object)this.namesToDelete.toArray());
        }
    }

    private void deleteCustomAttributeDeleteAction() {
        IStructuredSelection selection = this.namesToDeleteViewer.getStructuredSelection();
        Iterator it = selection.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                String e = (String)it.next();
                this.namesToDelete.remove(e);
            }
            this.namesToDeleteViewer.setInput((Object)this.namesToDelete.toArray());
        }
    }

    private void doApply() {
        this.rule.setCustomAttributeStorageSet(this.namesToSetEditor.getContent());
        this.rule.setCustomAttributeStorageDelete(this.namesToDelete);
        this.editor.setModified(true);
    }

    protected void performApply() {
        this.doApply();
    }

    public boolean performOk() {
        this.doApply();
        return super.performOk();
    }
}

