/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.snmp.SnmpUsmCredential;
import org.netxms.ui.eclipse.snmp.Messages;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;
import org.netxms.ui.eclipse.widgets.PasswordInputField;

public class EditSnmpUsmCredentialsDialog
extends Dialog {
    private LabeledText name;
    private PasswordInputField authPasswd;
    private PasswordInputField privPasswd;
    private LabeledText comment;
    private Combo authMethod;
    private Combo privMethod;
    private SnmpUsmCredential credentials;

    public EditSnmpUsmCredentialsDialog(Shell parentShell, SnmpUsmCredential credentials) {
        super(parentShell);
        this.credentials = credentials;
    }

    protected void configureShell(Shell newShell) {
        String string;
        super.configureShell(newShell);
        if (this.credentials == null) {
            Messages.get();
            string = Messages.AddUsmCredDialog_Title;
        } else {
            string = "Edit SNMP USM Credentials";
        }
        newShell.setText(string);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        Messages.get();
        this.name.setLabel(Messages.AddUsmCredDialog_UserName);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.name.setLayoutData((Object)gd);
        Messages.get();
        this.authMethod = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)Messages.AddUsmCredDialog_Auth, (Object)"WidgetHelper::default_layout_data");
        Messages.get();
        this.authMethod.add(Messages.AddUsmCredDialog_AuthTypeNone);
        Messages.get();
        this.authMethod.add(Messages.AddUsmCredDialog_AuthTypeMD5);
        Messages.get();
        this.authMethod.add(Messages.AddUsmCredDialog_AuthTypeSHA1);
        this.authMethod.add("SHA224");
        this.authMethod.add("SHA256");
        this.authMethod.add("SHA384");
        this.authMethod.add("SHA512");
        this.authMethod.select(2);
        Messages.get();
        this.privMethod = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)Messages.AddUsmCredDialog_Encryption, (Object)"WidgetHelper::default_layout_data");
        Messages.get();
        this.privMethod.add(Messages.AddUsmCredDialog_EncTypeNone);
        Messages.get();
        this.privMethod.add(Messages.AddUsmCredDialog_EncTypeDES);
        Messages.get();
        this.privMethod.add(Messages.AddUsmCredDialog_EncTypeAES);
        this.privMethod.select(2);
        this.authPasswd = new PasswordInputField(dialogArea, 0);
        Messages.get();
        this.authPasswd.setLabel(Messages.AddUsmCredDialog_AuthPasswd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.authPasswd.setLayoutData((Object)gd);
        this.privPasswd = new PasswordInputField(dialogArea, 0);
        Messages.get();
        this.privPasswd.setLabel(Messages.AddUsmCredDialog_EncPasswd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.privPasswd.setLayoutData((Object)gd);
        this.comment = new LabeledText(dialogArea, 0);
        this.comment.setLabel("Comments");
        this.comment.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.comment.setLayoutData((Object)gd);
        if (this.credentials != null) {
            this.name.setText(this.credentials.getName());
            this.authMethod.select(this.credentials.getAuthMethod());
            this.privMethod.select(this.credentials.getPrivMethod());
            this.authPasswd.setText(this.credentials.getAuthPassword());
            this.privPasswd.setText(this.credentials.getPrivPassword());
            this.comment.setText(this.credentials.getComment());
        }
        return dialogArea;
    }

    protected void okPressed() {
        if (this.credentials == null) {
            this.credentials = new SnmpUsmCredential();
        }
        this.credentials.setName(this.name.getText().trim());
        this.credentials.setAuthMethod(this.authMethod.getSelectionIndex());
        this.credentials.setPrivMethod(this.privMethod.getSelectionIndex());
        this.credentials.setAuthPassword(this.authPasswd.getText());
        this.credentials.setPrivPassword(this.privPasswd.getText());
        this.credentials.setComment(this.comment.getText());
        super.okPressed();
    }

    public SnmpUsmCredential getCredentials() {
        return this.credentials;
    }
}

