/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.slm.propertypages;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.BusinessServicePrototype;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class InstanceDiscovery
extends PropertyPage {
    public static final List<String> DISCOVERY_TYPES = Arrays.asList(null, "Agent List", "Agent Table", null, null, "Script", null, null, null);
    private BusinessServicePrototype object;
    private Combo discoveryMethod;
    private LabeledText discoveryData;
    private ObjectSelector instanceSourceSelector;
    private ScriptEditor filterScript;

    protected Control createContents(Composite parent) {
        this.object = (BusinessServicePrototype)this.getElement().getAdapter(BusinessServicePrototype.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.discoveryMethod = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)"Instance discovery method", (Object)"WidgetHelper::default_layout_data");
        for (String type : DISCOVERY_TYPES) {
            if (type == null) continue;
            this.discoveryMethod.add(type);
        }
        this.discoveryMethod.select(this.discoveryMethod.indexOf(DISCOVERY_TYPES.get(this.object.getInstanceDiscoveryMethod())));
        this.discoveryMethod.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int method = DISCOVERY_TYPES.indexOf(InstanceDiscovery.this.discoveryMethod.getText());
                InstanceDiscovery.this.discoveryData.setLabel(InstanceDiscovery.getDataLabel(method));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.instanceSourceSelector = new ObjectSelector(dialogArea, 0, true);
        this.instanceSourceSelector.setLabel("Source");
        this.instanceSourceSelector.setObjectClass(Node.class);
        this.instanceSourceSelector.setObjectId(this.object.getSourceNode());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.instanceSourceSelector.setLayoutData((Object)gd);
        this.discoveryData = new LabeledText(dialogArea, 0);
        this.discoveryData.setLabel(InstanceDiscovery.getDataLabel(this.object.getInstanceDiscoveryMethod()));
        this.discoveryData.setText(this.object.getInstanceDiscoveryData());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.discoveryData.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 0;
        gd.heightHint = 0;
        WidgetFactory factory = new WidgetFactory(){

            public Control createControl(Composite dialogArea, int style) {
                return new ScriptEditor(dialogArea, style, 768, false, "Variables:\r\n\t$1\t\t\tInstance to test;\r\n\t$2\t\t\tInstance data (secondary value for Script method);\r\n\t$node\t\trelated node;\r\n\t$prototype\t\tthis business service prototype object;\r\n\r\nReturn value:\r\n\ttrue/false to accept or reject instance without additional changes or\r\n\tarray of one or two elements to accept instance while modifying it:\r\n\t\t1st element - new instance name;\r\n\t\t2nd element - new instance display name.");
            }
        };
        this.filterScript = (ScriptEditor)WidgetHelper.createLabeledControl((Composite)dialogArea, (int)2048, (WidgetFactory)factory, (String)"Instance discovery filter script", (Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.filterScript.setLayoutData((Object)gd);
        this.filterScript.setText(this.object.getInstanceDiscoveryFilter());
        return dialogArea;
    }

    private static String getDataLabel(int method) {
        switch (method) {
            case 0: {
                return "Discovery data";
            }
            case 1: {
                return "List name";
            }
            case 2: 
            case 8: {
                return "Table name";
            }
            case 3: 
            case 4: {
                return "Base SNMP OID";
            }
            case 5: {
                return "Script name";
            }
            case 7: {
                return "Web service request";
            }
            case 6: {
                return "Object name";
            }
        }
        return "";
    }

    private boolean applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setInstanceDiscoveryMethod(DISCOVERY_TYPES.indexOf(this.discoveryMethod.getText()));
        md.setInstanceDiscoveryData(this.discoveryData.getText());
        md.setInstanceDiscoveryFilter(this.filterScript.getText());
        md.setSourceNode(Long.valueOf(this.instanceSourceSelector.getObjectId()));
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob(String.format("Modify instance discovery for busines service prototype %s", this.object.getObjectName()), null, "org.netxms.ui.eclipse.slm"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            InstanceDiscovery.this.setValid(true);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Cannot modify instance discovery settings";
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.discoveryMethod.select(this.discoveryMethod.indexOf(DISCOVERY_TYPES.get(5)));
        this.discoveryData.setLabel(InstanceDiscovery.getDataLabel(5));
        this.discoveryData.setText("");
        this.filterScript.setText("");
    }
}

