/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.internal.ActionSetContributionItem;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.services.IServiceLocator;
import org.netxms.base.VersionInfo;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.BrandingManager;
import org.netxms.ui.eclipse.console.LicenseProblemStatusLineItem;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.ServerClockContributionItem;
import org.netxms.ui.eclipse.console.ServerNameStatusLineItem;
import org.netxms.ui.eclipse.console.StatusLineContributionItem;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.views.BrowserView;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private ActionFactory.IWorkbenchAction actionExit;
    private ActionFactory.IWorkbenchAction actionAbout;
    private Action actionAboutCustom;
    private Action actionOpenManual;
    private ActionFactory.IWorkbenchAction actionShowPreferences;
    private ActionFactory.IWorkbenchAction actionCustomizePerspective;
    private ActionFactory.IWorkbenchAction actionSavePerspective;
    private ActionFactory.IWorkbenchAction actionResetPerspective;
    private ActionFactory.IWorkbenchAction actionClosePerspective;
    private ActionFactory.IWorkbenchAction actionCloseAllPerspectives;
    private Action actionMinimize;
    private Action actionMaximize;
    private Action actionClose;
    private ActionFactory.IWorkbenchAction actionPrevView;
    private ActionFactory.IWorkbenchAction actionNextView;
    private ActionFactory.IWorkbenchAction actionQuickAccess;
    private ActionFactory.IWorkbenchAction actionShowViewMenu;
    private Action actionOpenProgressView;
    private Action actionFullScreen;
    private Action actionLangArabic;
    private Action actionLangCzech;
    private Action actionLangEnglish;
    private Action actionLangFrench;
    private Action actionLangGerman;
    private Action actionLangHebrew;
    private Action actionLangPortuguese;
    private Action actionLangRussian;
    private Action actionLangSpanish;
    private IContributionItem contribItemOpenPerspective;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(final IWorkbenchWindow window) {
        this.contribItemOpenPerspective = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(window);
        this.actionExit = ActionFactory.QUIT.create(window);
        this.register((IAction)this.actionExit);
        this.actionAbout = ActionFactory.ABOUT.create(window);
        this.register((IAction)this.actionAbout);
        Messages.get();
        this.actionAboutCustom = new Action(Messages.ApplicationActionBarAdvisor_About){

            public void run() {
                Dialog dlg = BrandingManager.getInstance().getAboutDialog(window.getShell());
                if (dlg != null) {
                    dlg.open();
                } else {
                    Shell shell = window.getShell();
                    Messages.get();
                    Messages.get();
                    MessageDialogHelper.openInformation(shell, Messages.ApplicationActionBarAdvisor_AboutTitle, String.format(Messages.ApplicationActionBarAdvisor_AboutText, VersionInfo.version()));
                }
            }
        };
        this.actionOpenManual = new Action("Open Administrator &Guide"){

            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                try {
                    BrowserView view = (BrowserView)window.getActivePage().showView("org.netxms.ui.eclipse.views.BrowserView", "AdminGuide", 1);
                    view.setFixedTitle("Administrator Guide");
                    view.openUrl("https://netxms.org/documentation/adminguide/");
                }
                catch (PartInitException e) {
                    MessageDialogHelper.openError(window.getShell(), "Error", String.format("Cannot open browser view (%s)", e.getLocalizedMessage()));
                }
            }
        };
        this.actionShowPreferences = ActionFactory.PREFERENCES.create(window);
        this.register((IAction)this.actionShowPreferences);
        this.actionCustomizePerspective = ActionFactory.EDIT_ACTION_SETS.create(window);
        this.register((IAction)this.actionCustomizePerspective);
        this.actionSavePerspective = ActionFactory.SAVE_PERSPECTIVE.create(window);
        this.register((IAction)this.actionSavePerspective);
        this.actionResetPerspective = ActionFactory.RESET_PERSPECTIVE.create(window);
        this.register((IAction)this.actionResetPerspective);
        this.actionClosePerspective = ActionFactory.CLOSE_PERSPECTIVE.create(window);
        this.register((IAction)this.actionClosePerspective);
        this.actionCloseAllPerspectives = ActionFactory.CLOSE_ALL_PERSPECTIVES.create(window);
        this.register((IAction)this.actionCloseAllPerspectives);
        this.actionMinimize = new CommandAction((IServiceLocator)window, "org.eclipse.ui.window.maximizePart");
        this.register((IAction)this.actionMinimize);
        this.actionMaximize = new CommandAction((IServiceLocator)window, "org.eclipse.ui.window.minimizePart");
        this.register((IAction)this.actionMaximize);
        this.actionClose = new CommandAction((IServiceLocator)window, "org.eclipse.ui.file.closePart");
        this.register((IAction)this.actionClose);
        this.actionPrevView = ActionFactory.PREVIOUS_PART.create(window);
        this.register((IAction)this.actionPrevView);
        this.actionNextView = ActionFactory.NEXT_PART.create(window);
        this.register((IAction)this.actionNextView);
        this.actionQuickAccess = ActionFactory.SHOW_QUICK_ACCESS.create(window);
        this.register((IAction)this.actionQuickAccess);
        this.actionShowViewMenu = ActionFactory.SHOW_VIEW_MENU.create(window);
        this.register((IAction)this.actionShowViewMenu);
        this.actionOpenProgressView = new Action(){

            public void run() {
                IWorkbenchPage page;
                IWorkbenchWindow win;
                IWorkbench wb = PlatformUI.getWorkbench();
                if (wb != null && (win = wb.getActiveWorkbenchWindow()) != null && (page = win.getActivePage()) != null) {
                    try {
                        page.showView("org.eclipse.ui.views.ProgressView");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        Messages.get();
        this.actionOpenProgressView.setText(Messages.ApplicationActionBarAdvisor_Progress);
        this.actionOpenProgressView.setImageDescriptor(Activator.getImageDescriptor("icons/pview.gif"));
        Messages.get();
        this.actionFullScreen = new Action(Messages.ApplicationActionBarAdvisor_FullScreen, 2){

            public void run() {
                boolean fullScreen = !PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getFullScreen();
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setFullScreen(fullScreen);
                ApplicationActionBarAdvisor.this.actionFullScreen.setChecked(fullScreen);
            }
        };
        this.actionFullScreen.setChecked(false);
        this.actionFullScreen.setId("org.netxms.ui.eclipse.console.actions.full_screen");
        this.actionFullScreen.setActionDefinitionId("org.netxms.ui.eclipse.console.commands.full_screen");
        this.getActionBarConfigurer().registerGlobalAction((IAction)this.actionFullScreen);
        ConsoleSharedData.setProperty("FullScreenAction", this.actionFullScreen);
        this.actionLangArabic = new Action("&Arabic", Activator.getImageDescriptor("icons/lang/ar.png")){

            public void run() {
                ApplicationActionBarAdvisor.this.setLanguage("ar");
            }
        };
        this.actionLangCzech = new Action("&Czech", Activator.getImageDescriptor("icons/lang/cs.png")){

            public void run() {
                ApplicationActionBarAdvisor.this.setLanguage("cs");
            }
        };
        this.actionLangEnglish = new Action("&English", Activator.getImageDescriptor("icons/lang/gb.png")){

            public void run() {
                ApplicationActionBarAdvisor.this.setLanguage("en");
            }
        };
        this.actionLangFrench = new Action("&French", Activator.getImageDescriptor("icons/lang/fr.png")){

            public void run() {
                ApplicationActionBarAdvisor.this.setLanguage("fr");
            }
        };
        this.actionLangGerman = new Action("&German", Activator.getImageDescriptor("icons/lang/de.png")){

            public void run() {
                ApplicationActionBarAdvisor.this.setLanguage("de");
            }
        };
        this.actionLangHebrew = new Action("&Hebrew", Activator.getImageDescriptor("icons/lang/iw.png")){

            public void run() {
                ApplicationActionBarAdvisor.this.setLanguage("iw");
            }
        };
        this.actionLangPortuguese = new Action("&Portuguese (Brazilian)", Activator.getImageDescriptor("icons/lang/pt_br.png")){

            public void run() {
                ApplicationActionBarAdvisor.this.setLanguage("pt_BR");
            }
        };
        this.actionLangRussian = new Action("&Russian", Activator.getImageDescriptor("icons/lang/ru.png")){

            public void run() {
                ApplicationActionBarAdvisor.this.setLanguage("ru");
            }
        };
        this.actionLangSpanish = new Action("&Spanish", Activator.getImageDescriptor("icons/lang/es.png")){

            public void run() {
                ApplicationActionBarAdvisor.this.setLanguage("es");
            }
        };
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        Messages.get();
        MenuManager fileMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_File, "file");
        Messages.get();
        MenuManager viewMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_View, "view");
        Messages.get();
        MenuManager monitorMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_Monitor, "monitor");
        Messages.get();
        MenuManager toolsMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_Tools, "tools");
        Messages.get();
        MenuManager windowMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_Window, "window");
        Messages.get();
        MenuManager helpMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_Help, "help");
        Messages.get();
        MenuManager configMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_Configuration, "config"){

            protected void itemAdded(IContributionItem item) {
                IContributionItem[] items = this.getItems();
                Arrays.sort(items, new Comparator<IContributionItem>(){

                    @Override
                    public int compare(IContributionItem item1, IContributionItem item2) {
                        if (item1 instanceof ActionSetContributionItem) {
                            item1 = ((ActionSetContributionItem)item1).getInnerItem();
                        }
                        if (item2 instanceof ActionSetContributionItem) {
                            item2 = ((ActionSetContributionItem)item2).getInnerItem();
                        }
                        String n1 = item1 instanceof ActionContributionItem ? ((ActionContributionItem)item1).getAction().getText().replace("&", "") : item1.getId();
                        String n2 = item2 instanceof ActionContributionItem ? ((ActionContributionItem)item2).getAction().getText().replace("&", "") : item2.getId();
                        return n1.compareToIgnoreCase(n2);
                    }
                });
                this.internalSetItems(items);
                super.itemAdded(item);
            }
        };
        menuBar.add((IContributionItem)fileMenu);
        menuBar.add((IContributionItem)viewMenu);
        menuBar.add((IContributionItem)monitorMenu);
        menuBar.add((IContributionItem)configMenu);
        menuBar.add((IContributionItem)toolsMenu);
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        if (!Activator.getDefault().getPreferenceStore().getBoolean("HIDE_WINDOW_MENU")) {
            menuBar.add((IContributionItem)windowMenu);
        }
        menuBar.add((IContributionItem)helpMenu);
        MenuManager langMenu = new MenuManager("&Language");
        langMenu.add((IAction)this.actionLangArabic);
        langMenu.add((IAction)this.actionLangCzech);
        langMenu.add((IAction)this.actionLangEnglish);
        langMenu.add((IAction)this.actionLangFrench);
        langMenu.add((IAction)this.actionLangGerman);
        langMenu.add((IAction)this.actionLangHebrew);
        langMenu.add((IAction)this.actionLangPortuguese);
        langMenu.add((IAction)this.actionLangRussian);
        langMenu.add((IAction)this.actionLangSpanish);
        fileMenu.add((IAction)this.actionShowPreferences);
        fileMenu.add((IContributionItem)langMenu);
        fileMenu.add((IContributionItem)new GroupMarker("additions"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.actionExit);
        viewMenu.add((IContributionItem)new GroupMarker("product"));
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IContributionItem)new GroupMarker("primary"));
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IContributionItem)new GroupMarker("logs"));
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IAction)this.actionOpenProgressView);
        viewMenu.add((IContributionItem)new GroupMarker("tools"));
        monitorMenu.add((IContributionItem)new GroupMarker("additions"));
        configMenu.add((IContributionItem)new GroupMarker("additions"));
        toolsMenu.add((IContributionItem)new GroupMarker("additions"));
        Messages.get();
        MenuManager openPerspectiveMenuMgr = new MenuManager(Messages.ApplicationActionBarAdvisor_OpenPerspective, "openPerspective");
        openPerspectiveMenuMgr.add(this.contribItemOpenPerspective);
        windowMenu.add((IContributionItem)openPerspectiveMenuMgr);
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IAction)this.actionCustomizePerspective);
        windowMenu.add((IAction)this.actionSavePerspective);
        windowMenu.add((IAction)this.actionResetPerspective);
        windowMenu.add((IAction)this.actionClosePerspective);
        windowMenu.add((IAction)this.actionCloseAllPerspectives);
        windowMenu.add((IContributionItem)new Separator());
        Messages.get();
        MenuManager navMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_Navigation, "navigate");
        windowMenu.add((IContributionItem)navMenu);
        navMenu.add((IAction)this.actionQuickAccess);
        navMenu.add((IAction)this.actionShowViewMenu);
        navMenu.add((IContributionItem)new Separator());
        navMenu.add((IAction)this.actionMaximize);
        navMenu.add((IAction)this.actionMinimize);
        navMenu.add((IAction)this.actionClose);
        navMenu.add((IContributionItem)new Separator());
        navMenu.add((IAction)this.actionNextView);
        navMenu.add((IAction)this.actionPrevView);
        helpMenu.add((IAction)this.actionOpenManual);
        helpMenu.add((IContributionItem)new GroupMarker("additions"));
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IAction)(BrandingManager.getInstance().getAboutDialog(null) != null ? this.actionAboutCustom : this.actionAbout));
    }

    private void addToolBar(ICoolBarManager coolBar, String id) {
        if (coolBar.find(id) != null) {
            return;
        }
        ToolBarManager toolbar = new ToolBarManager(0x820000);
        toolbar.add((IContributionItem)new GroupMarker("additions"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolbar, id));
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        this.addToolBar(coolBar, "product");
        this.addToolBar(coolBar, "view");
        this.addToolBar(coolBar, "logs");
        this.addToolBar(coolBar, "tools");
        this.addToolBar(coolBar, "config");
        if (Activator.getDefault().getPreferenceStore().getBoolean("SHOW_SERVER_CLOCK") && coolBar.find("org.netxms.ui.eclipse.console.ServerClockContribution") == null) {
            coolBar.add((IContributionItem)new ServerClockContributionItem());
        }
        ConsoleSharedData.setProperty("CoolBarManager", coolBar);
        coolBar.setLockLayout(true);
    }

    protected void fillStatusLine(IStatusLineManager statusLine) {
        Activator.getDefault().setStatusLine(statusLine);
        if (ConsoleSharedData.getSession().hasLicenseProblems()) {
            statusLine.add((IContributionItem)new LicenseProblemStatusLineItem("LicenseProblem", -1));
        }
        StatusLineContributionItem statusItem = new StatusLineContributionItem("ConnectionStatus", -1);
        statusItem.setText("");
        statusLine.add((IContributionItem)statusItem);
        statusLine.add((IContributionItem)new ServerNameStatusLineItem("ServerName"));
        StatusLineContributionItem syncStatusItem = new StatusLineContributionItem("ObjectSyncStatus");
        syncStatusItem.setText("");
        statusLine.add((IContributionItem)syncStatusItem);
    }

    private void setLanguage(String locale) {
        block24: {
            Messages.get();
            Messages.get();
            if (!MessageDialogHelper.openConfirm(null, Messages.ApplicationActionBarAdvisor_ConfirmRestart, Messages.ApplicationActionBarAdvisor_RestartConsoleMessage)) {
                return;
            }
            Activator.getDefault().getPreferenceStore().setValue("NL", locale);
            Location configArea = Platform.getInstallLocation();
            if (configArea != null) {
                BufferedReader in = null;
                BufferedWriter out = null;
                try {
                    try {
                        String line;
                        URL iniFileUrl = new URL(String.valueOf(configArea.getURL().toExternalForm()) + "nxmc.ini");
                        String iniFileName = iniFileUrl.getFile();
                        File iniFile = new File(iniFileName);
                        File iniFileBackup = new File(String.valueOf(iniFileName) + ".bak");
                        iniFileBackup.delete();
                        iniFile.renameTo(iniFileBackup);
                        in = new BufferedReader(new FileReader(String.valueOf(iniFileName) + ".bak"));
                        out = new BufferedWriter(new FileWriter(iniFileName));
                        int state = 0;
                        while ((line = in.readLine()) != null) {
                            switch (state) {
                                case 0: {
                                    if (!line.equals("-nl")) break;
                                    state = 1;
                                    break;
                                }
                                case 1: {
                                    line = locale;
                                    state = 0;
                                }
                            }
                            out.write(line);
                            out.newLine();
                        }
                    }
                    catch (Exception e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.netxms.ui.eclipse.console", 0, "Exception in setLanguage()", (Throwable)e));
                        try {
                            if (in != null) {
                                in.close();
                            }
                            if (out != null) {
                                out.close();
                            }
                            break block24;
                        }
                        catch (IOException iOException) {}
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        System.getProperties().setProperty("eclipse.exitdata", "-nl " + locale);
        PlatformUI.getWorkbench().restart();
    }
}

