/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractTraceView;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.AbstractTraceWidget;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public abstract class AbstractTraceView
extends View {
    private final I18n i18n = LocalizationHelper.getI18n(AbstractTraceView.class);
    protected NXCSession session = Registry.getSession();
    protected AbstractTraceWidget traceWidget;
    private Action actionClear;
    private boolean subscribed = false;

    public AbstractTraceView(String name, ImageDescriptor image, String baseId) {
        super(name, image, baseId, true);
    }

    public void createContent(Composite parent) {
        this.traceWidget = this.createTraceWidget(parent);
        this.setFilterClient((ISelectionProvider)this.traceWidget.getViewer(), (AbstractViewerFilter)this.traceWidget.getFilter());
        this.createActions();
        this.createContextMenu();
    }

    public void activate() {
        super.activate();
        this.subscribe(this.getChannelName());
    }

    public void deactivate() {
        this.unsubscribe(this.getChannelName());
        super.deactivate();
    }

    public void dispose() {
        this.unsubscribe(this.getChannelName());
        super.dispose();
    }

    protected abstract AbstractTraceWidget createTraceWidget(Composite var1);

    protected abstract String getChannelName();

    protected AbstractTraceWidget getTraceWidget() {
        return this.traceWidget;
    }

    protected void createActions() {
        this.actionClear = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+L", (IAction)this.actionClear);
        this.addKeyBinding("M1+C", (IAction)this.traceWidget.getActionCopy());
        this.addKeyBinding("M1+P", (IAction)this.traceWidget.getActionPause());
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.traceWidget.getActionPause());
        manager.add((IAction)this.actionClear);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.traceWidget.getActionPause());
        manager.add((IAction)this.actionClear);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.traceWidget.getActionCopy());
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.traceWidget.getViewer().getControl());
        this.traceWidget.getViewer().getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
    }

    public void setFocus() {
        this.traceWidget.setFocus();
    }

    protected synchronized void subscribe(String channel) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected synchronized void unsubscribe(String channel) {
        if (!this.subscribed) {
            return;
        }
        this.subscribed = false;
        4 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }
}

