/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.assetmanagement.propertypages;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.asset.AssetAttribute;
import org.netxms.client.constants.AMDataType;
import org.netxms.client.constants.AMSystemType;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.assetmanagement.views.helpers.AssetAttributeListLabelProvider;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class AssetAttributeGeneral
extends PropertyPage {
    static final I18n i18n = LocalizationHelper.getI18n(AssetAttributeGeneral.class);
    private AssetAttribute attribute = null;
    private boolean createNew = false;
    private LabeledText textName;
    private LabeledText textDisplayName;
    private Combo comboDataType = null;
    private Button checkMandatory;
    private Button checkUnique;
    private Button checkHidden;
    private Button useLimits;
    private LabeledSpinner spinnerRangeMin;
    private LabeledSpinner spinnerRangeMax;
    private Combo comboSystemType;

    public AssetAttributeGeneral(AssetAttribute attribute, boolean createNew) {
        super("General");
        this.attribute = attribute;
        this.createNew = createNew;
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.textName = new LabeledText(dialogArea, 0);
        this.textName.setLabel("Name");
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 2;
        this.textName.setLayoutData((Object)gd);
        this.textName.setText(this.attribute.getName());
        this.textName.setEditable(this.createNew);
        this.textDisplayName = new LabeledText(dialogArea, 0);
        this.textDisplayName.setLabel("Display name");
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 2;
        this.textDisplayName.setLayoutData((Object)gd);
        this.textDisplayName.setText(this.attribute.getDisplayName());
        this.comboDataType = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)i18n.tr("Data type"), (Object)new GridData(4, 0x1000000, true, false));
        for (String s : AssetAttributeListLabelProvider.DATA_TYPES) {
            this.comboDataType.add(s);
        }
        this.comboDataType.select(this.attribute.getDataType().getValue());
        this.comboDataType.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.comboSystemType = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)i18n.tr("System type"), (Object)new GridData(4, 0x1000000, true, false));
        for (String s : AssetAttributeListLabelProvider.SYSTEM_TYPE) {
            this.comboSystemType.add(s);
        }
        this.comboSystemType.select(this.attribute.getSystemType().getValue());
        boolean haveLimits = this.attribute.getDataType() == AMDataType.STRING || this.attribute.getDataType() == AMDataType.NUMBER || this.attribute.getDataType() == AMDataType.INTEGER;
        this.useLimits = new Button(dialogArea, 32);
        this.useLimits.setText(i18n.tr("Use limits"));
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 2;
        this.useLimits.setLayoutData((Object)gd);
        this.useLimits.setSelection(this.attribute.getRangeMax() != 0 || this.attribute.getRangeMin() != 0);
        this.useLimits.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.useLimits.setEnabled(haveLimits);
        haveLimits = haveLimits && this.useLimits.getSelection();
        this.spinnerRangeMin = new LabeledSpinner(dialogArea, 0);
        this.spinnerRangeMin.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.spinnerRangeMin.setLabel(this.attribute.getDataType() == AMDataType.STRING ? i18n.tr("Minimum length") : i18n.tr("Minimum value"));
        this.spinnerRangeMin.setRange(this.attribute.getDataType() == AMDataType.STRING ? 0 : Integer.MIN_VALUE, this.attribute.getDataType() == AMDataType.STRING ? 255 : Integer.MAX_VALUE);
        this.spinnerRangeMin.setSelection(this.attribute.getRangeMin());
        this.spinnerRangeMax = new LabeledSpinner(dialogArea, 0);
        this.spinnerRangeMax.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.spinnerRangeMax.setLabel(this.attribute.getDataType() == AMDataType.STRING ? i18n.tr("Maximum length") : i18n.tr("Minimum value"));
        this.spinnerRangeMax.setRange(this.attribute.getDataType() == AMDataType.STRING ? 0 : Integer.MIN_VALUE, this.attribute.getDataType() == AMDataType.STRING ? 255 : Integer.MAX_VALUE);
        this.spinnerRangeMax.setSelection(this.attribute.getRangeMax());
        this.spinnerRangeMin.setEnabled(haveLimits);
        this.spinnerRangeMax.setEnabled(haveLimits);
        Composite optionsContainer = new Composite(dialogArea, 0);
        optionsContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        optionsContainer.setLayout((Layout)new GridLayout());
        this.checkMandatory = new Button(optionsContainer, 32);
        this.checkMandatory.setText(i18n.tr("&Mandatory"));
        this.checkMandatory.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.checkMandatory.setSelection(this.attribute.isMandatory());
        this.checkUnique = new Button(optionsContainer, 32);
        this.checkUnique.setText(i18n.tr("&Unique"));
        this.checkUnique.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.checkUnique.setSelection(this.attribute.isUnique());
        this.checkHidden = new Button(optionsContainer, 32);
        this.checkHidden.setText(i18n.tr("&Hidden"));
        this.checkHidden.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.checkHidden.setSelection(this.attribute.isUnique());
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        if (this.useLimits.getSelection() && this.spinnerRangeMin.getSelection() > this.spinnerRangeMax.getSelection()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)i18n.tr("Warning"), (String)i18n.tr("Minumun can't be lesst than maximum"));
            return false;
        }
        if (this.createNew) {
            String newName = this.textName.getText();
            if (newName.isEmpty()) {
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)i18n.tr("Warning"), (String)i18n.tr("Name can't be empty"));
                return false;
            }
            if (!Registry.getSession().isAssetAttributeUnique(newName)) {
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)i18n.tr("Warning"), (String)i18n.tr("Name should be unique"));
                return false;
            }
            if (!newName.matches("[A-Za-z$_][A-Za-z0-9$_]*")) {
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)i18n.tr("Warning"), (String)i18n.tr("Name should be NXSL compliant"));
                return false;
            }
            this.attribute.setName(this.textName.getText());
        }
        this.attribute.setDisplayName(this.textDisplayName.getText());
        this.attribute.setDataType(AMDataType.getByValue((int)this.comboDataType.getSelectionIndex()));
        this.attribute.setSystemType(AMSystemType.getByValue((int)this.comboSystemType.getSelectionIndex()));
        if (this.useLimits.getSelection()) {
            this.attribute.setRangeMin(this.spinnerRangeMin.getSelection());
            this.attribute.setRangeMax(this.spinnerRangeMax.getSelection());
        } else {
            this.attribute.setRangeMin(0);
            this.attribute.setRangeMax(0);
        }
        this.attribute.setMandatory(this.checkMandatory.getSelection());
        this.attribute.setUnique(this.checkUnique.getSelection());
        this.attribute.setHidden(this.checkHidden.getSelection());
        return true;
    }
}

