/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.elements;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.PollState;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.interfaces.PollingTarget;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.elements.OverviewPageElement;
import org.netxms.nxmc.modules.objects.views.elements.TableElement;
import org.xnap.commons.i18n.I18n;

public class PollStates
extends TableElement {
    private final I18n i18n = LocalizationHelper.getI18n(PollStates.class);
    private Map<String, String> typeNames = new HashMap();

    public PollStates(Composite parent, OverviewPageElement anchor, ObjectView objectView) {
        super(parent, anchor, objectView);
        this.typeNames.put("autobind", this.i18n.tr("Autobind"));
        this.typeNames.put("configuration", this.i18n.tr("Configuration"));
        this.typeNames.put("discovery", this.i18n.tr("Network discovery"));
        this.typeNames.put("icmp", this.i18n.tr("ICMP"));
        this.typeNames.put("instance", this.i18n.tr("Instance discovery"));
        this.typeNames.put("routing", this.i18n.tr("Routing table"));
        this.typeNames.put("status", this.i18n.tr("Status"));
        this.typeNames.put("topology", this.i18n.tr("Topology"));
    }

    public boolean isApplicableForObject(AbstractObject object) {
        return object instanceof PollingTarget && ((PollingTarget)object).getPollStates() != null;
    }

    protected void fillTable() {
        for (PollState s : ((PollingTarget)this.getObject()).getPollStates()) {
            String type = (String)this.typeNames.get(s.getPollType());
            if (type == null) {
                type = s.getPollType();
            }
            if (s.isPending()) {
                this.addPair(type, this.i18n.tr("pending"));
                continue;
            }
            Date lastCompleted = s.getLastCompleted();
            this.addPair(type, lastCompleted.getTime() > 0L ? DateFormatFactory.getTimeFormat().format(lastCompleted) : this.i18n.tr("never"));
        }
    }

    protected String getTitle() {
        return "Polls";
    }
}

