/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.console.dialogs.SendNotificationDialog;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class SendNotification
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        if (this.window == null) {
            return;
        }
        final SendNotificationDialog dlg = new SendNotificationDialog(this.window.getShell());
        if (dlg.open() != 0) {
            return;
        }
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Send notification to" + dlg.getRecipient(), this.window.getActivePage().getActivePart(), "org.netxms.ui.eclipse.console", null){

            @Override
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.sendNotification(dlg.getChannelName(), dlg.getRecipient(), dlg.getSubject(), dlg.getMessage());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        String message = String.format("Notification to %s has been enqueued", dlg.getRecipient());
                        MessageDialogHelper.openInformation((this).SendNotification.this.window.getShell(), "Send Notification", message);
                    }
                });
            }

            @Override
            protected String getErrorMessage() {
                return String.format("Cannot send notification to %s", dlg.getRecipient());
            }
        }.start();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

