/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.AgentFileData;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.server.ServerJobIdUpdater;
import org.netxms.client.xml.XMLTools;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.FileMonitorConfig;
import org.netxms.ui.eclipse.filemanager.widgets.DynamicFileViewer;
import org.netxms.ui.eclipse.jobs.ConsoleJobCallingServerJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMonitorElement
extends ElementWidget {
    private static final Logger logger = LoggerFactory.getLogger(FileMonitorElement.class);
    private FileMonitorConfig config;
    private DynamicFileViewer viewer;
    private NXCSession session;

    protected FileMonitorElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = (FileMonitorConfig)XMLTools.createFromXml(FileMonitorConfig.class, (String)element.getData());
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e);
            this.config = new FileMonitorConfig();
        }
        this.processCommonSettings(this.config);
        this.session = ConsoleSharedData.getSession();
        this.viewer = new DynamicFileViewer(this.getContentArea(), 0, viewPart);
        this.viewer.setLineCountLimit(this.config.getHistoryLimit());
        this.viewer.setAppendFilter(this.config.getFilter());
        final long nodeId = this.getEffectiveObjectId(this.config.getObjectId());
        new ConsoleJobCallingServerJob(String.format("Starting monitor for file \"%s\" on node \"%s\"", this.config.getFileName(), this.session.getObjectName(nodeId)), (IWorkbenchPart)viewPart, "org.netxms.ui.eclipse.dashboard"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    final AgentFileData file = FileMonitorElement.this.session.downloadFileFromAgent(nodeId, FileMonitorElement.this.config.getFileName(), 1024L, true, null, (ServerJobIdUpdater)this);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).FileMonitorElement.this.viewer.showFile(file.getFile(), true);
                            (this).FileMonitorElement.this.viewer.startTracking(file.getMonitorId(), nodeId, file.getRemoteName());
                        }
                    });
                }
                catch (Exception e) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).FileMonitorElement.this.viewer.startTracking(null, nodeId, (this).FileMonitorElement.this.config.getFileName());
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return String.format("Error downloading file %s from node %s", FileMonitorElement.this.config.getFileName(), FileMonitorElement.this.session.getObjectName(nodeId));
            }
        }.start();
    }
}

