/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.widgets;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.netxms.client.reporting.ReportParameter;
import org.netxms.ui.eclipse.reporter.Activator;
import org.netxms.ui.eclipse.reporter.Messages;
import org.netxms.ui.eclipse.reporter.widgets.FieldEditor;
import org.netxms.ui.eclipse.tools.ImageCache;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class DateFieldEditor
extends FieldEditor {
    private static final int FIELD_YEAR = 0;
    private static final int FIELD_MONTH = 1;
    private static final int FIELD_DAY = 2;
    private Combo[] dateElements;

    public DateFieldEditor(ReportParameter parameter, Composite parent) {
        super(parameter, parent);
    }

    @Override
    protected Control createContent(Composite parent) {
        ImageCache imageCache = new ImageCache((Control)this);
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 2;
        layout.makeColumnsEqualWidth = true;
        content.setLayout((Layout)layout);
        Calendar dateTime = Calendar.getInstance();
        try {
            dateTime.setTime(new Date(Long.parseLong(this.parameter.getDefaultValue()) * 1000L));
        }
        catch (NumberFormatException e) {
            dateTime.setTime(new Date());
        }
        String[] stringArray = new String[3];
        Messages.get();
        stringArray[0] = Messages.DateFieldEditor_Year;
        Messages.get();
        stringArray[1] = Messages.DateFieldEditor_Month;
        Messages.get();
        stringArray[2] = Messages.DateFieldEditor_Day;
        String[] dateElementNames = stringArray;
        this.dateElements = new Combo[dateElementNames.length];
        int idx = 0;
        while (idx < dateElementNames.length) {
            Combo cb = WidgetHelper.createLabeledCombo((Composite)content, (int)2048, (String)dateElementNames[idx], (Object)"WidgetHelper::default_layout_data");
            cb.setText(this.getDateTimeText(idx, dateTime));
            cb.add("current");
            cb.add("first");
            cb.add("last");
            cb.add("next");
            cb.add("previous");
            this.dateElements[idx] = cb;
            ++idx;
        }
        final ImageHyperlink link = new ImageHyperlink(content, 0);
        link.setImage(imageCache.add(Activator.getImageDescriptor("icons/calendar-large.png")));
        Messages.get();
        link.setToolTipText(Messages.DateFieldEditor_Calendar);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DateFieldEditor.this.createPopupCalendar((Control)link);
            }
        });
        GridData gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.horizontalAlignment = 16384;
        gd.verticalAlignment = 0x1000000;
        gd.horizontalIndent = 5;
        link.setLayoutData((Object)gd);
        return content;
    }

    @Override
    public String getValue() {
        String value = null;
        int idx = 0;
        while (idx < 3) {
            value = idx == 0 ? this.dateElements[idx].getText() : String.valueOf(value) + ";" + this.dateElements[idx].getText();
            ++idx;
        }
        return value;
    }

    private String getDateTimeText(int fieldIndex, Calendar calendar) {
        int value;
        switch (fieldIndex) {
            case 0: {
                value = calendar.get(1);
                break;
            }
            case 1: {
                value = calendar.get(2) + 1;
                break;
            }
            case 2: {
                value = calendar.get(5);
                break;
            }
            default: {
                value = 0;
            }
        }
        return String.valueOf(value);
    }

    private void createPopupCalendar(Control anchor) {
        WidgetHelper.createPopupCalendar((Shell)this.getShell(), (Control)anchor, null, date -> {
            int idx = 0;
            while (idx < this.dateElements.length) {
                this.dateElements[idx].setText(this.getDateTimeText(idx, (Calendar)date));
                ++idx;
            }
        });
    }
}

