/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.SSHCredentials;
import org.netxms.client.SshKeyPair;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;
import org.netxms.ui.eclipse.widgets.PasswordInputField;

public class EditSSHCredentialsDialog
extends Dialog {
    private LabeledText login;
    private PasswordInputField password;
    private Combo key;
    private SSHCredentials credentials;
    private List<SshKeyPair> sshKeys;

    public EditSSHCredentialsDialog(Shell parentShell, SSHCredentials credentials, List<SshKeyPair> sshKeys) {
        super(parentShell);
        this.credentials = credentials;
        this.sshKeys = sshKeys;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.credentials == null ? "Add SSH Credentials" : "Edit SSH Credentials");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.login = new LabeledText(dialogArea, 0);
        this.login.setLabel("Login");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.login.setLayoutData((Object)gd);
        this.password = new PasswordInputField(dialogArea, 0);
        this.password.setLabel("Password");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.password.setLayoutData((Object)gd);
        this.key = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"SSH Key", (Object)"WidgetHelper::default_layout_data");
        this.key.add("");
        int i = 0;
        while (i < this.sshKeys.size()) {
            SshKeyPair kp = this.sshKeys.get(i);
            this.key.add(kp.getName());
            if (this.credentials != null && kp.getId() == this.credentials.getKeyId()) {
                this.key.select(this.key.getItemCount() - 1);
            }
            ++i;
        }
        if (this.credentials != null) {
            this.login.setText(this.credentials.getLogin());
            this.password.setText(this.credentials.getPassword());
        }
        return dialogArea;
    }

    protected void okPressed() {
        int keyId;
        int index = this.key.getSelectionIndex();
        int n = keyId = index > 0 ? this.sshKeys.get(index - 1).getId() : 0;
        if (this.login.getText().trim().equals("")) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)"Login should not be empty.");
            return;
        }
        if (this.password.getText().equals("") && keyId == 0) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)"Either password or key should be provided.");
            return;
        }
        if (this.credentials == null) {
            this.credentials = new SSHCredentials(this.login.getText().trim(), this.password.getText(), keyId);
        } else {
            this.credentials.setLogin(this.login.getText().trim());
            this.credentials.setPassword(this.password.getText().trim());
            this.credentials.setKeyId(keyId);
        }
        super.okPressed();
    }

    public SSHCredentials getCredentials() {
        return this.credentials;
    }
}

