/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.layouts.algorithms;

import org.eclipse.gef4.zest.layouts.LayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.AlgorithmHelper;
import org.eclipse.gef4.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.dataStructures.DisplayIndependentPoint;
import org.eclipse.gef4.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.gef4.zest.layouts.interfaces.EntityLayout;
import org.eclipse.gef4.zest.layouts.interfaces.LayoutContext;

public class RadialLayoutAlgorithm
implements LayoutAlgorithm {
    private static final double MAX_DEGREES = Math.PI * 2;
    private double startDegree = 0.0;
    private double endDegree = Math.PI * 2;
    private LayoutContext context;
    private boolean resize = false;
    private TreeLayoutAlgorithm treeLayout = new TreeLayoutAlgorithm();

    public RadialLayoutAlgorithm(int style) {
        this();
        this.setResizing(style != 1);
    }

    public RadialLayoutAlgorithm() {
    }

    @Override
    public void applyLayout(boolean clean) {
        if (!clean) {
            return;
        }
        this.treeLayout.internalApplyLayout();
        EntityLayout[] entities = this.context.getEntities();
        DisplayIndependentRectangle bounds = this.context.getBounds();
        this.computeRadialPositions(entities, bounds);
        if (this.resize) {
            AlgorithmHelper.maximizeSizes(entities);
        }
        int insets = 4;
        bounds.x += (double)insets;
        bounds.y += (double)insets;
        bounds.width -= (double)(2 * insets);
        bounds.height -= (double)(2 * insets);
        AlgorithmHelper.fitWithinBounds(entities, bounds, this.resize);
    }

    private void computeRadialPositions(EntityLayout[] entities, DisplayIndependentRectangle bounds) {
        DisplayIndependentRectangle layoutBounds = AlgorithmHelper.getLayoutBounds(entities, false);
        layoutBounds.x = bounds.x;
        layoutBounds.width = bounds.width;
        int i = 0;
        while (i < entities.length) {
            DisplayIndependentPoint location = entities[i].getLocation();
            double percenttheta = (location.x - layoutBounds.x) / layoutBounds.width;
            double distance = (location.y - layoutBounds.y) / layoutBounds.height;
            double theta = this.startDegree + Math.abs(this.endDegree - this.startDegree) * percenttheta;
            location.x = distance * Math.cos(theta);
            location.y = distance * Math.sin(theta);
            entities[i].setLocation(location.x, location.y);
            ++i;
        }
    }

    @Override
    public void setLayoutContext(LayoutContext context) {
        this.context = context;
        this.treeLayout.setLayoutContext(context);
    }

    public void setRangeToLayout(double startDegree, double endDegree) {
        this.startDegree = startDegree;
        this.endDegree = endDegree;
    }

    public boolean isResizing() {
        return this.resize;
    }

    public void setResizing(boolean resizing) {
        this.resize = resizing;
        this.treeLayout.setResizing(this.resize);
    }
}

