/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.ui.eclipse.datacollection.views.helpers.DciLabelProvider;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class DciComparator
extends ViewerComparator {
    private DciLabelProvider labelProvider;

    public DciComparator(DciLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        DataCollectionObject dci1 = (DataCollectionObject)e1;
        DataCollectionObject dci2 = (DataCollectionObject)e2;
        int column = (Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID");
        switch (column) {
            case 0: {
                result = (int)(dci1.getId() - dci2.getId());
                break;
            }
            case 1: {
                result = dci1.getDescription().compareToIgnoreCase(dci2.getDescription());
                break;
            }
            case 3: {
                result = dci1.getName().compareToIgnoreCase(dci2.getName());
                break;
            }
            case 6: {
                result = dci1.getComparablePollingInterval() - dci2.getComparablePollingInterval();
                break;
            }
            case 7: {
                result = dci1.getComparableRetentionTime() - dci2.getComparableRetentionTime();
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                String text1 = this.labelProvider.getColumnText(e1, column);
                String text2 = this.labelProvider.getColumnText(e2, column);
                if (text1 != null && text2 != null) {
                    result = text1.compareToIgnoreCase(text2);
                    break;
                }
                if (text1 == null) {
                    if (text2 == null) {
                        result = 0;
                        break;
                    }
                    result = -1;
                    break;
                }
                result = 1;
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }
}

