/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps.configs;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.netxms.base.Glob;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.maps.configs.DCIImageRule;
import org.netxms.client.maps.configs.SingleDciConfig;
import org.netxms.client.xml.XMLTools;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Serializer;

@Root(name="dciImageConfiguration")
public class DCIImageConfiguration {
    public static final int OP_LE = 0;
    public static final int OP_LE_EQ = 1;
    public static final int OP_EQ = 2;
    public static final int OP_GT_EQ = 3;
    public static final int OP_GT = 4;
    public static final int OP_NE = 5;
    public static final int OP_LIKE = 6;
    public static final int OP_NOTLIKE = 7;
    @ElementArray(required=true)
    private DCIImageRule[] dciRuleList = new DCIImageRule[0];
    @Element(required=true)
    private SingleDciConfig dci = new SingleDciConfig();
    @Element(required=true)
    private UUID defaultImage = null;

    public String createXml() throws Exception {
        Serializer serializer = XMLTools.createSerializer();
        StringWriter writer = new StringWriter();
        serializer.write((Object)this, (Writer)writer);
        return ((Object)writer).toString();
    }

    public DCIImageRule[] getDciRuleArray() {
        return this.dciRuleList;
    }

    public void setDciRuleArray(DCIImageRule[] dciRuleList) {
        this.dciRuleList = dciRuleList;
    }

    public List<DCIImageRule> getRulesAsList() {
        ArrayList<DCIImageRule> rules = new ArrayList<DCIImageRule>();
        if (this.containRuleList()) {
            DCIImageRule[] dCIImageRuleArray = this.dciRuleList;
            int n = this.dciRuleList.length;
            int n2 = 0;
            while (n2 < n) {
                DCIImageRule dci = dCIImageRuleArray[n2];
                rules.add(dci);
                ++n2;
            }
        }
        return rules;
    }

    public SingleDciConfig getDci() {
        return this.dci;
    }

    public void setDci(SingleDciConfig dci) {
        this.dci = dci;
    }

    public UUID getDefaultImage() {
        return this.defaultImage;
    }

    public void setDefaultImage(UUID defaultImage) {
        this.defaultImage = defaultImage;
    }

    public boolean containRuleList() {
        return this.dciRuleList != null && this.dciRuleList.length > 0;
    }

    public UUID getCorrectImage(DciValue dciValue) {
        UUID image = null;
        if (this.containRuleList() && dciValue != null) {
            int i = 0;
            while (i < this.dciRuleList.length) {
                switch (this.dciRuleList[i].getComparisonType()) {
                    case 0: {
                        if (this.compareValues(dciValue.getValue(), this.dciRuleList[i].getCompareValue(), dciValue.getDataType()) >= 0) break;
                        image = this.dciRuleList[i].getImage();
                        break;
                    }
                    case 1: {
                        if (this.compareValues(dciValue.getValue(), this.dciRuleList[i].getCompareValue(), dciValue.getDataType()) > 0) break;
                        image = this.dciRuleList[i].getImage();
                        break;
                    }
                    case 2: {
                        if (this.compareValues(dciValue.getValue(), this.dciRuleList[i].getCompareValue(), dciValue.getDataType()) != 0) break;
                        image = this.dciRuleList[i].getImage();
                        break;
                    }
                    case 3: {
                        if (this.compareValues(dciValue.getValue(), this.dciRuleList[i].getCompareValue(), dciValue.getDataType()) < 0) break;
                        image = this.dciRuleList[i].getImage();
                        break;
                    }
                    case 4: {
                        if (this.compareValues(dciValue.getValue(), this.dciRuleList[i].getCompareValue(), dciValue.getDataType()) <= 0) break;
                        image = this.dciRuleList[i].getImage();
                        break;
                    }
                    case 5: {
                        if (this.compareValues(dciValue.getValue(), this.dciRuleList[i].getCompareValue(), dciValue.getDataType()) == 0) break;
                        image = this.dciRuleList[i].getImage();
                        break;
                    }
                    case 6: {
                        if (!Glob.matchIgnoreCase((String)this.dciRuleList[i].getCompareValue(), (String)dciValue.getValue())) break;
                        image = this.dciRuleList[i].getImage();
                        break;
                    }
                    case 7: {
                        if (Glob.matchIgnoreCase((String)this.dciRuleList[i].getCompareValue(), (String)dciValue.getValue())) break;
                        image = this.dciRuleList[i].getImage();
                    }
                }
                if (image != null) break;
                ++i;
            }
        }
        return image != null ? image : this.defaultImage;
    }

    private int compareValues(String value1, String value2, DataType dataType) {
        int result = 0;
        try {
            switch (dataType) {
                case INT32: 
                case UINT32: {
                    result = Integer.valueOf(value1).compareTo(Integer.valueOf(value2));
                    break;
                }
                case FLOAT: {
                    result = Float.valueOf(value1).compareTo(Float.valueOf(value2));
                    break;
                }
                case INT64: 
                case UINT64: {
                    result = Long.valueOf(value1).compareTo(Long.valueOf(value2));
                    break;
                }
                default: {
                    result = value1.compareTo(value2);
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            result = value1.compareTo(value2);
        }
        return result;
    }
}

