/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.views;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.resources.SharedIcons;

public class BrowserView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.views.BrowserView";
    private String title = null;
    private String initialUrl = null;
    private Browser browser;
    private Action actionBack;
    private Action actionForward;
    private Action actionStop;
    private Action actionReload;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String string = this.initialUrl = memento != null ? memento.getString("URL") : null;
        if (this.initialUrl != null && this.initialUrl.isEmpty()) {
            this.initialUrl = null;
        }
        String string2 = this.title = memento != null ? memento.getString("Title") : null;
        if (this.title != null && this.title.isEmpty()) {
            this.title = null;
        }
        super.init(site, memento);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString("URL", this.browser.getUrl());
        memento.putString("Title", this.title != null ? this.title : "");
    }

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 0);
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                if (BrowserView.this.title == null) {
                    Messages.get();
                    BrowserView.this.setPartName(String.format(Messages.BrowserView_PartName_Changing, event.location));
                }
                BrowserView.this.actionStop.setEnabled(true);
            }

            public void changed(LocationEvent event) {
                if (BrowserView.this.title == null) {
                    Messages.get();
                    BrowserView.this.setPartName(String.format(Messages.BrowserView_PartName_Changed, BrowserView.getTitle(BrowserView.this.browser.getText(), event.location)));
                }
                BrowserView.this.actionStop.setEnabled(false);
            }
        });
        this.createActions();
        this.contributeToActionBars();
        if (this.title != null) {
            this.setPartName(this.title);
        }
        if (this.initialUrl != null) {
            this.openUrl(this.initialUrl);
        }
    }

    private void createActions() {
        Messages.get();
        this.actionBack = new Action(Messages.BrowserView_Back, SharedIcons.NAV_BACKWARD){

            public void run() {
                BrowserView.this.browser.back();
            }
        };
        Messages.get();
        this.actionForward = new Action(Messages.BrowserView_Forward, SharedIcons.NAV_FORWARD){

            public void run() {
                BrowserView.this.browser.forward();
            }
        };
        Messages.get();
        this.actionStop = new Action(Messages.BrowserView_Stop, Activator.getImageDescriptor("icons/stop.png")){

            public void run() {
                BrowserView.this.browser.stop();
            }
        };
        this.actionReload = new RefreshAction((IViewPart)this){

            public void run() {
                BrowserView.this.browser.refresh();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionBack);
        manager.add((IAction)this.actionForward);
        manager.add((IAction)this.actionStop);
        manager.add((IAction)this.actionReload);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionBack);
        manager.add((IAction)this.actionForward);
        manager.add((IAction)this.actionStop);
        manager.add((IAction)this.actionReload);
    }

    public void setFocus() {
        if (!this.browser.isDisposed()) {
            this.browser.setFocus();
        }
    }

    public void setFixedTitle(String title) {
        this.title = title;
        this.setPartName(title);
    }

    public void openUrl(String url) {
        this.browser.setUrl(url);
    }

    private static String getTitle(String html, String fallback) {
        Pattern p = Pattern.compile("\\<html\\>.*\\<head\\>.*\\<title\\>(.*)\\</title\\>.*", 34);
        Matcher m = p.matcher(html);
        if (m.matches()) {
            int index = m.start(1);
            if (index == -1) {
                return fallback;
            }
            return html.substring(index, m.end(1));
        }
        return fallback;
    }
}

