/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.preferencepages;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.dialogs.ThemeEditDialog;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.resources.DefaultDarkTheme;
import org.netxms.nxmc.resources.DefaultLightTheme;
import org.netxms.nxmc.resources.Theme;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ThemesPage
extends PropertyPage {
    private static final Logger logger = LoggerFactory.getLogger(ThemesPage.class);
    private Combo themeSelector;
    private Button importButton;
    private Button exportButton;
    private Button newButton;
    private Button editButton;
    private Button removeButton;
    private List<Theme> themes = new ArrayList();

    public ThemesPage() {
        super("Themes");
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.numColumns = 6;
        dialogArea.setLayout((Layout)layout);
        this.loadThemes();
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 4;
        this.themeSelector = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2060, (String)"Active theme", (Object)gd);
        this.updateThemeDropDown();
        String currentTheme = PreferenceStore.getInstance().getAsString("CurrentTheme");
        if (currentTheme != null && !currentTheme.isEmpty()) {
            int index = this.themeSelector.indexOf(currentTheme);
            this.themeSelector.select(index != -1 ? index : 0);
        } else {
            this.themeSelector.select(0);
        }
        this.themeSelector.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editButton = new Button(dialogArea, 8);
        this.editButton.setText("&Edit...");
        gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.widthHint = 90;
        this.editButton.setLayoutData((Object)gd);
        this.editButton.setEnabled(this.themeSelector.getSelectionIndex() > 2);
        this.editButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeButton = new Button(dialogArea, 8);
        this.removeButton.setText("&Remove");
        gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.widthHint = 90;
        this.removeButton.setLayoutData((Object)gd);
        this.removeButton.setEnabled(this.themeSelector.getSelectionIndex() > 2);
        this.removeButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.importButton = new Button(dialogArea, 8);
        this.importButton.setText("&Import...");
        gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.widthHint = 90;
        this.importButton.setLayoutData((Object)gd);
        this.importButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.newButton = new Button(dialogArea, 8);
        this.newButton.setText("&New...");
        gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.widthHint = 90;
        this.newButton.setLayoutData((Object)gd);
        this.newButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.exportButton = new Button(dialogArea, 8);
        this.exportButton.setText("E&xport...");
        gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.widthHint = 90;
        this.exportButton.setLayoutData((Object)gd);
        this.exportButton.setEnabled(this.themeSelector.getSelectionIndex() > 2);
        this.exportButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    private void onThemeSelectionChange() {
        int index = this.themeSelector.getSelectionIndex();
        this.editButton.setEnabled(index > 2);
        this.removeButton.setEnabled(index > 2);
        this.exportButton.setEnabled(index > 2);
    }

    private void selectTheme(Theme theme) {
        int index = this.themeSelector.indexOf(theme.getName());
        this.themeSelector.select(index != -1 ? index : 0);
        this.onThemeSelectionChange();
    }

    private void updateThemeDropDown() {
        this.themes.sort(new /* Unavailable Anonymous Inner Class!! */);
        this.themeSelector.removeAll();
        this.themeSelector.add("[automatic]");
        this.themeSelector.add("Light [built-in]");
        this.themeSelector.add("Dark [built-in]");
        for (Theme t : this.themes) {
            this.themeSelector.add(t.getName());
        }
    }

    private void loadThemes() {
        File base = ThemeEngine.getThemeStorageDirectory();
        if (base.isDirectory()) {
            for (File f : base.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */)) {
                try {
                    Theme t = Theme.load((File)f);
                    t.setMissingElements(ThemesPage.getAutomaticTheme());
                    this.themes.add(t);
                }
                catch (Exception e) {
                    logger.error("Error loading theme file " + f.getAbsolutePath(), (Throwable)e);
                }
            }
        }
    }

    private void addNewTheme() {
        int index = this.themeSelector.getSelectionIndex();
        Theme theme = new Theme("New Theme", switch (index) {
            case 0 -> ThemesPage.getAutomaticTheme();
            case 1 -> new DefaultLightTheme();
            case 2 -> new DefaultDarkTheme();
            default -> (Theme)this.themes.get(index - 3);
        });
        ThemeEditDialog dlg = new ThemeEditDialog(this.getShell(), theme);
        if (dlg.open() == 0) {
            try {
                ThemeEngine.saveTheme((Theme)theme);
                this.themes.add(theme);
                this.updateThemeDropDown();
                this.selectTheme(theme);
            }
            catch (Exception e) {
                MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)String.format("Cannot save theme (%s)", e.getLocalizedMessage()));
                logger.error("Cannot save theme", (Throwable)e);
            }
        }
    }

    private void importTheme() {
        FileDialog dlg = new FileDialog(this.getShell(), 4096);
        dlg.setFilterExtensions(new String[]{"*.xml", "*.*"});
        String importFileName = dlg.open();
        if (importFileName == null) {
            return;
        }
        try {
            Theme theme = Theme.load((File)new File(importFileName));
            ThemeEngine.saveTheme((Theme)theme);
            this.themes.add(theme);
            this.updateThemeDropDown();
            this.selectTheme(theme);
        }
        catch (Exception e) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)String.format("Cannot import theme (%s)", e.getLocalizedMessage()));
            logger.error("Cannot import theme", (Throwable)e);
        }
    }

    private void editTheme() {
        int index = this.themeSelector.getSelectionIndex();
        if (index < 3) {
            return;
        }
        Theme theme = (Theme)this.themes.get(index - 3);
        String oldName = theme.getName();
        ThemeEditDialog dlg = new ThemeEditDialog(this.getShell(), theme);
        if (dlg.open() == 0) {
            try {
                if (!oldName.equals(theme.getName())) {
                    ThemeEngine.deleteTheme((String)oldName);
                }
                ThemeEngine.saveTheme((Theme)theme);
                this.updateThemeDropDown();
                this.selectTheme(theme);
            }
            catch (Exception e) {
                MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)String.format("Cannot save theme (%s)", e.getLocalizedMessage()));
                logger.error("Cannot save theme", (Throwable)e);
            }
        }
    }

    private void removeTheme() {
        int index = this.themeSelector.getSelectionIndex();
        if (index < 3) {
            return;
        }
        Theme theme = (Theme)this.themes.get(index - 3);
        if (!MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)"Remove Theme", (String)String.format("Theme %s will be removed. Are you sure?", theme.getName()))) {
            return;
        }
        ThemeEngine.deleteTheme((String)theme.getName());
        this.updateThemeDropDown();
        this.themeSelector.select(0);
        this.onThemeSelectionChange();
    }

    private void exportTheme() {
        int index = this.themeSelector.getSelectionIndex();
        if (index < 3) {
            return;
        }
        Theme theme = (Theme)this.themes.get(index - 3);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.themeSelector.select(0);
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.exportButton.setEnabled(false);
    }

    protected boolean applyChanges(boolean isApply) {
        PreferenceStore.getInstance().set("CurrentTheme", this.themeSelector.getText());
        ThemeEngine.reload();
        return true;
    }

    private static Theme getAutomaticTheme() {
        return WidgetHelper.isSystemDarkTheme() ? new DefaultDarkTheme() : new DefaultLightTheme();
    }
}

