/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class EmbeddedProgressMonitor
extends Composite
implements IProgressMonitor {
    ProgressMonitorPart monitor;

    public EmbeddedProgressMonitor(Composite parent, int style, boolean showStopButton) {
        super(parent, style);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.setLayout((Layout)layout);
        this.monitor = new ProgressMonitorPart((Composite)this, null);
    }

    private void updateUI(Runnable r) {
        Display display = this.getDisplay();
        if (Thread.currentThread() == display.getThread()) {
            r.run();
        } else {
            display.asyncExec(r);
        }
    }

    public void beginTask(String name, int totalWork) {
        this.updateUI(() -> this.monitor.beginTask(name, totalWork));
    }

    public void done() {
        this.updateUI(() -> this.monitor.done());
    }

    public void internalWorked(double work) {
        this.updateUI(() -> this.monitor.internalWorked(work));
    }

    public boolean isCanceled() {
        return this.monitor.isCanceled();
    }

    public void setCanceled(boolean value) {
        this.monitor.setCanceled(value);
    }

    public void setTaskName(String name) {
        this.updateUI(() -> this.monitor.setTaskName(name));
    }

    public void subTask(String name) {
        this.updateUI(() -> this.monitor.subTask(name));
    }

    public void worked(int work) {
        this.updateUI(() -> this.monitor.worked(work));
    }
}

