/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.actions.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.client.NotificationChannel;
import org.netxms.client.ServerAction;
import org.netxms.client.constants.ServerActionType;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledCombo;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.actions.dialogs.EditActionDlg;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class EditActionDlg
extends Dialog {
    private static final I18n i18n = LocalizationHelper.getI18n(EditActionDlg.class);
    private ServerAction action;
    private boolean createNew;
    private Text name;
    private LabeledText recipient;
    private LabeledText subject;
    private LabeledText data;
    private LabeledCombo channelName;
    private Button typeLocalExec;
    private Button typeRemoteExec;
    private Button typeRemoteSshExec;
    private Button typeExecScript;
    private Button typeNotification;
    private Button typeForward;
    private Button markDisabled;
    private List<NotificationChannel> notificationChannels = null;

    public EditActionDlg(Shell parentShell, ServerAction action, boolean createNew) {
        super(parentShell);
        this.action = action;
        this.createNew = createNew;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.createNew ? i18n.tr("Create Action") : i18n.tr("Edit Action"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        this.name = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)300, (String)i18n.tr("Name"), (String)this.action.getName(), (Object)"WidgetHelper::default_layout_data");
        Group typeGroup = new Group(dialogArea, 0);
        typeGroup.setText(i18n.tr("Type"));
        typeGroup.setLayout((Layout)new RowLayout(512));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        typeGroup.setLayoutData((Object)gd);
        this.typeLocalExec = new Button((Composite)typeGroup, 16);
        this.typeLocalExec.setText(i18n.tr("Execute command on management server"));
        this.typeLocalExec.setSelection(this.action.getType() == ServerActionType.LOCAL_COMMAND);
        this.typeLocalExec.addSelectionListener((SelectionListener)new TypeButtonSelectionListener(this));
        this.typeRemoteExec = new Button((Composite)typeGroup, 16);
        this.typeRemoteExec.setText(i18n.tr("Execute command on remote node via agent"));
        this.typeRemoteExec.setSelection(this.action.getType() == ServerActionType.AGENT_COMMAND);
        this.typeRemoteExec.addSelectionListener((SelectionListener)new TypeButtonSelectionListener(this));
        this.typeRemoteSshExec = new Button((Composite)typeGroup, 16);
        this.typeRemoteSshExec.setText(i18n.tr("Execute command on remote node via SSH"));
        this.typeRemoteSshExec.setSelection(this.action.getType() == ServerActionType.SSH_COMMAND);
        this.typeRemoteSshExec.addSelectionListener((SelectionListener)new TypeButtonSelectionListener(this));
        this.typeExecScript = new Button((Composite)typeGroup, 16);
        this.typeExecScript.setText(i18n.tr("Execute &NXSL script"));
        this.typeExecScript.setSelection(this.action.getType() == ServerActionType.NXSL_SCRIPT);
        this.typeExecScript.addSelectionListener((SelectionListener)new TypeButtonSelectionListener(this));
        this.typeNotification = new Button((Composite)typeGroup, 16);
        this.typeNotification.setText(i18n.tr("Send notification"));
        this.typeNotification.setSelection(this.action.getType() == ServerActionType.NOTIFICATION);
        this.typeNotification.addSelectionListener((SelectionListener)new TypeButtonSelectionListener(this));
        this.typeForward = new Button((Composite)typeGroup, 16);
        this.typeForward.setText(i18n.tr("Forward event to other NetXMS server"));
        this.typeForward.setSelection(this.action.getType() == ServerActionType.FORWARD_EVENT);
        this.typeForward.addSelectionListener((SelectionListener)new TypeButtonSelectionListener(this));
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText(i18n.tr("Options"));
        optionsGroup.setLayout((Layout)new RowLayout(512));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        this.markDisabled = new Button((Composite)optionsGroup, 32);
        this.markDisabled.setText(i18n.tr("Action is &disabled"));
        this.markDisabled.setSelection(this.action.isDisabled());
        this.channelName = new LabeledCombo(dialogArea, 0);
        this.channelName.setLabel(i18n.tr("Channel name"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.channelName.setLayoutData((Object)gd);
        this.channelName.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.recipient = new LabeledText(dialogArea, 0);
        this.recipient.setLabel(this.getRcptLabel(this.action.getType()));
        this.recipient.setText(this.action.getRecipientAddress());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.recipient.setLayoutData((Object)gd);
        this.subject = new LabeledText(dialogArea, 0);
        this.subject.setLabel(i18n.tr("Subject"));
        this.subject.setText(this.action.getEmailSubject());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.subject.setLayoutData((Object)gd);
        this.data = new LabeledText(dialogArea, 0, 2050);
        this.data.setLabel(this.getDataLabel(this.action.getType()));
        this.data.getTextControl().setFont(JFaceResources.getTextFont());
        this.data.setText(this.action.getData());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 200;
        gd.widthHint = 400;
        this.data.setLayoutData((Object)gd);
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return dialogArea;
    }

    private String getRcptLabel(ServerActionType type) {
        switch (3.$SwitchMap$org$netxms$client$constants$ServerActionType[type.ordinal()]) {
            case 1: 
            case 2: {
                return i18n.tr("Remote host");
            }
            case 3: {
                return i18n.tr("Remote NetXMS server");
            }
            case 4: {
                return i18n.tr("Script name");
            }
        }
        return i18n.tr("Recipient's address");
    }

    private String getDataLabel(ServerActionType type) {
        switch (3.$SwitchMap$org$netxms$client$constants$ServerActionType[type.ordinal()]) {
            case 5: {
                return i18n.tr("Command");
            }
            case 1: 
            case 2: {
                return i18n.tr("Agent's action");
            }
        }
        return i18n.tr("Message text");
    }

    protected void okPressed() {
        if (this.typeLocalExec.getSelection()) {
            this.action.setType(ServerActionType.LOCAL_COMMAND);
        } else if (this.typeRemoteExec.getSelection()) {
            this.action.setType(ServerActionType.AGENT_COMMAND);
        } else if (this.typeRemoteSshExec.getSelection()) {
            this.action.setType(ServerActionType.SSH_COMMAND);
        } else if (this.typeExecScript.getSelection()) {
            this.action.setType(ServerActionType.NXSL_SCRIPT);
        } else if (this.typeNotification.getSelection()) {
            this.action.setType(ServerActionType.NOTIFICATION);
        } else if (this.typeForward.getSelection()) {
            this.action.setType(ServerActionType.FORWARD_EVENT);
        }
        this.action.setName(this.name.getText());
        this.action.setRecipientAddress(this.recipient.getText());
        this.action.setEmailSubject(this.subject.getText());
        this.action.setData(this.data.getText());
        this.action.setDisabled(this.markDisabled.getSelection());
        if (this.typeNotification.getSelection()) {
            this.action.setChannelName(((NotificationChannel)this.notificationChannels.get(this.channelName.getSelectionIndex())).getName());
        } else {
            this.action.setChannelName("");
        }
        super.okPressed();
    }

    private void updateChannelList() {
        this.channelName.removeAll();
        boolean needRecipient = false;
        boolean needSubject = false;
        for (int i = 0; i < this.notificationChannels.size(); ++i) {
            NotificationChannel nc = (NotificationChannel)this.notificationChannels.get(i);
            this.channelName.add(nc.getName());
            if (!nc.getName().equals(this.action.getChannelName())) continue;
            this.channelName.select(i);
            needRecipient = nc.getConfigurationTemplate().needRecipient;
            needSubject = nc.getConfigurationTemplate().needSubject;
        }
        this.recipient.setEnabled(needRecipient);
        this.subject.setEnabled(needSubject);
    }

    private void onTypeChange() {
        ServerActionType type = null;
        if (this.typeLocalExec.getSelection()) {
            type = ServerActionType.LOCAL_COMMAND;
        } else if (this.typeRemoteExec.getSelection()) {
            type = ServerActionType.AGENT_COMMAND;
        } else if (this.typeRemoteSshExec.getSelection()) {
            type = ServerActionType.SSH_COMMAND;
        } else if (this.typeExecScript.getSelection()) {
            type = ServerActionType.NXSL_SCRIPT;
        } else if (this.typeNotification.getSelection()) {
            type = ServerActionType.NOTIFICATION;
        } else if (this.typeForward.getSelection()) {
            type = ServerActionType.FORWARD_EVENT;
        }
        if (type == null) {
            return;
        }
        switch (3.$SwitchMap$org$netxms$client$constants$ServerActionType[type.ordinal()]) {
            case 5: {
                this.channelName.setEnabled(false);
                this.recipient.setEnabled(false);
                this.subject.setEnabled(false);
                this.data.setEnabled(true);
                break;
            }
            case 1: 
            case 2: {
                this.channelName.setEnabled(false);
                this.recipient.setEnabled(true);
                this.subject.setEnabled(false);
                this.data.setEnabled(true);
                break;
            }
            case 3: 
            case 4: {
                this.channelName.setEnabled(false);
                this.recipient.setEnabled(true);
                this.subject.setEnabled(false);
                this.data.setEnabled(false);
                break;
            }
            case 6: {
                this.channelName.setEnabled(true);
                this.updateChannelList();
                this.data.setEnabled(true);
            }
        }
        this.recipient.setLabel(this.getRcptLabel(type));
        this.data.setLabel(this.getDataLabel(type));
    }
}

