/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.alarms.widgets;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.client.events.AlarmComment;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.ImageHyperlink;
import org.netxms.nxmc.base.widgets.events.HyperlinkAdapter;
import org.netxms.nxmc.base.widgets.events.IHyperlinkListener;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.ImageCache;
import org.xnap.commons.i18n.I18n;

public class AlarmCommentsEditor
extends Composite {
    private static final I18n i18n = LocalizationHelper.getI18n(AlarmCommentsEditor.class);
    private NXCSession session = Registry.getSession();
    private Text text;

    public AlarmCommentsEditor(Composite parent, ImageCache imageCache, AlarmComment comment, HyperlinkAdapter editAction, HyperlinkAdapter deleteAction) {
        super(parent, 2048);
        this.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.setLayout((Layout)layout);
        CLabel user = new CLabel((Composite)this, 0);
        AbstractUserObject userObject = this.session.findUserDBObjectById(comment.getUserId(), (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        user.setImage(imageCache.create(ResourceManager.getImageDescriptor((String)"icons/user.png")));
        user.setText(userObject != null ? userObject.getName() : i18n.tr(" <unknown>"));
        user.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        user.setLayoutData((Object)gd);
        Label time = new Label((Composite)this, 0);
        time.setText(DateFormatFactory.getDateTimeFormat().format(comment.getLastChangeTime()));
        time.setBackground(parent.getBackground());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        time.setLayoutData((Object)gd);
        Composite controlArea = new Composite((Composite)this, 0);
        controlArea.setBackground(parent.getBackground());
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        controlArea.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.verticalAlignment = 128;
        gd.verticalSpan = 2;
        controlArea.setLayoutData((Object)gd);
        ImageHyperlink linkEdit = new ImageHyperlink(controlArea, 0);
        linkEdit.setText(i18n.tr("Edit"));
        linkEdit.setImage(SharedIcons.IMG_EDIT);
        linkEdit.setBackground(parent.getBackground());
        linkEdit.addHyperlinkListener((IHyperlinkListener)editAction);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        linkEdit.setLayoutData((Object)gd);
        ImageHyperlink linkDelete = new ImageHyperlink(controlArea, 0);
        linkDelete.setText(i18n.tr("Delete"));
        linkDelete.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkDelete.setBackground(parent.getBackground());
        linkDelete.addHyperlinkListener((IHyperlinkListener)deleteAction);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        linkDelete.setLayoutData((Object)gd);
        this.text = new Text((Composite)this, 74);
        this.text.setText(comment.getText());
        this.text.setBackground(parent.getBackground());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.text.setLayoutData((Object)gd);
    }
}

