/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.assetmanagement.views;

import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.asset.AssetAttribute;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.assetmanagement.propertypages.AssetAttributeAutoFillScript;
import org.netxms.nxmc.modules.assetmanagement.propertypages.AssetAttributeEnums;
import org.netxms.nxmc.modules.assetmanagement.propertypages.AssetAttributeGeneral;
import org.netxms.nxmc.modules.assetmanagement.views.AssetManagementSchemaManager;
import org.netxms.nxmc.modules.assetmanagement.views.helpers.AssetAttributeComparator;
import org.netxms.nxmc.modules.assetmanagement.views.helpers.AssetAttributeFilter;
import org.netxms.nxmc.modules.assetmanagement.views.helpers.AssetAttributeListLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class AssetManagementSchemaManager
extends ConfigurationView {
    private static final I18n i18n = LocalizationHelper.getI18n(AssetManagementSchemaManager.class);
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_DISPLAY_NAME = 1;
    public static final int COLUMN_DATA_TYPE = 2;
    public static final int COLUMN_IS_MANDATORY = 3;
    public static final int COLUMN_IS_UNIQUE = 4;
    public static final int COLUMN_IS_HIDDEN = 5;
    public static final int COLUMN_HAS_SCRIPT = 6;
    public static final int COLUMN_RANGE_MIN = 7;
    public static final int COLUMN_RANGE_MAX = 8;
    public static final int COLUMN_SYSTEM_TYPE = 9;
    Map<String, AssetAttribute> schema = null;
    private NXCSession session = Registry.getSession();
    private SessionListener listener;
    private SortableTableViewer viewer;
    private AssetAttributeFilter filter;
    private Action actionAdd;
    private Action actionEdit;
    private Action actionDelete;

    public AssetManagementSchemaManager() {
        super(i18n.tr("Asset Management Schema"), ResourceManager.getImageDescriptor((String)"icons/config-views/scheduled-tasks.png"), "AssetManagementSchema", true);
    }

    protected void createContent(Composite parent) {
        int[] widths = new int[]{200, 200, 100, 100, 100, 100, 100, 100, 100, 100};
        String[] names = new String[]{i18n.tr("Name"), i18n.tr("Display Name"), i18n.tr("Data Type"), i18n.tr("Mandatory"), i18n.tr("Unique"), i18n.tr("Hidden"), i18n.tr("Autofill"), i18n.tr("Range min"), i18n.tr("Range max"), i18n.tr("System type")};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AssetAttributeListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new AssetAttributeComparator());
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.filter = new AssetAttributeFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"AssetManagementAttributes");
        this.viewer.getControl().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.listener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.listener);
        this.createActions();
        this.createContextMenu();
        this.refresh();
    }

    private void createActions() {
        this.actionAdd = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+N", (IAction)this.actionAdd);
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M3+ENTER", (IAction)this.actionEdit);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+D", (IAction)this.actionDelete);
    }

    protected void deleteAttribute() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)i18n.tr("Delete Attribute"), (String)i18n.tr("Selected attributes will be deleted. Are you sure?"))) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void editAttribute() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        AssetAttribute attr = (AssetAttribute)selection.getFirstElement();
        if (!this.showAttributePropertyPage(attr, false)) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void createAttribute() {
        AssetAttribute attr = new AssetAttribute();
        if (!this.showAttributePropertyPage(attr, true)) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private boolean showAttributePropertyPage(AssetAttribute attribute, boolean isNew) {
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("general", (IPreferencePage)new AssetAttributeGeneral(attribute, isNew)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("script", (IPreferencePage)new AssetAttributeAutoFillScript(attribute)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("enum", (IPreferencePage)new AssetAttributeEnums(attribute)));
        10 dlg = new /* Unavailable Anonymous Inner Class!! */;
        dlg.setBlockOnOpen(true);
        return dlg.open() == 0;
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionAdd);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionAdd);
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = manager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionAdd);
        mgr.add((IAction)this.actionEdit);
        mgr.add((IAction)this.actionDelete);
    }

    public void refresh() {
        this.schema = this.session.getAssetManagementSchema();
        this.viewer.setInput(this.schema.values());
    }

    public void dispose() {
        if (this.listener != null && this.session != null) {
            this.session.removeListener(this.listener);
        }
        super.dispose();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

