/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.businessservice.views.helpers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.businessservices.BusinessServiceCheck;
import org.netxms.client.constants.BusinessServiceCheckType;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.datacollection.DciInfo;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.interfaces.NodeChild;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.businessservice.views.helpers.BusinessServiceCheckLabelProvider;
import org.netxms.nxmc.modules.objects.widgets.helpers.BaseObjectLabelProvider;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.resources.ThemeEngine;
import org.xnap.commons.i18n.I18n;

public class BusinessServiceCheckLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private final I18n i18n = LocalizationHelper.getI18n(BusinessServiceCheckLabelProvider.class);
    private final String[] TYPES = new String[]{this.i18n.tr("None"), this.i18n.tr("Script"), this.i18n.tr("DCI threshold"), this.i18n.tr("Object status")};
    private Color prototypeColor = ThemeEngine.getForegroundColor((String)"List.DisabledItem");
    private NXCSession session = Registry.getSession();
    private Map<Long, DciInfo> dciNameCache = new HashMap();
    private BaseObjectLabelProvider objectLabelProvider = new BaseObjectLabelProvider();

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 3) {
            return null;
        }
        BusinessServiceCheck check = (BusinessServiceCheck)element;
        AbstractObject object = this.session.findObjectById(check.getObjectId());
        return object != null ? this.objectLabelProvider.getImage((Object)object) : null;
    }

    public String getColumnText(Object element, int columnIndex) {
        BusinessServiceCheck check = (BusinessServiceCheck)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(check.getId());
            }
            case 1: {
                return check.getDescription();
            }
            case 2: {
                return this.getTypeName(check);
            }
            case 3: {
                return this.getObjectName(check);
            }
            case 4: {
                return this.getDciName(check);
            }
            case 5: {
                return this.getCheckStateText(check);
            }
            case 6: {
                return check.getFailureReason();
            }
            case 7: {
                return this.getOriginName(check);
            }
        }
        return null;
    }

    public String getCheckStateText(BusinessServiceCheck check) {
        switch (1.$SwitchMap$org$netxms$client$constants$BusinessServiceState[check.getState().ordinal()]) {
            case 1: {
                return this.i18n.tr("OK");
            }
            case 2: {
                return this.i18n.tr("Degraded");
            }
            case 3: {
                return this.i18n.tr("Failed");
            }
        }
        return null;
    }

    public String getObjectName(BusinessServiceCheck check) {
        if (check.getObjectId() == 0L) {
            return "";
        }
        StringBuilder name = new StringBuilder();
        AbstractObject object = this.session.findObjectById(check.getObjectId());
        if (object != null) {
            name.append(object.getObjectName());
            if (object instanceof NodeChild) {
                name.append(" @ ");
                AbstractNode node = ((NodeChild)object).getParentNode();
                name.append(node.getObjectName());
            }
        } else {
            name.append("[");
            name.append(Long.toString(check.getObjectId()));
            name.append("]");
        }
        return name.toString();
    }

    public String getOriginName(BusinessServiceCheck check) {
        if (check.getPrototypeServiceId() == 0L) {
            return "";
        }
        StringBuilder name = new StringBuilder();
        AbstractObject object = this.session.findObjectById(check.getPrototypeServiceId());
        if (object != null) {
            name.append(object.getObjectName());
        } else {
            name.append("[");
            name.append(Long.toString(check.getObjectId()));
            name.append("]");
        }
        return name.toString();
    }

    public String getDciName(BusinessServiceCheck check) {
        if (check.getCheckType() != BusinessServiceCheckType.DCI || check.getDciId() == 0L) {
            return "";
        }
        String name = ((DciInfo)this.dciNameCache.get((Object)Long.valueOf((long)check.getDciId()))).displayName;
        return name != null ? name : "[" + Long.toString(check.getDciId()) + "]";
    }

    public String getTypeName(BusinessServiceCheck check) {
        return this.TYPES[check.getCheckType().getValue()];
    }

    public Color getForeground(Object element, int columnIndex) {
        if (columnIndex != 5) {
            return null;
        }
        switch (1.$SwitchMap$org$netxms$client$constants$BusinessServiceState[((BusinessServiceCheck)element).getState().ordinal()]) {
            case 1: {
                return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.NORMAL);
            }
            case 2: {
                return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.MINOR);
            }
            case 3: {
                return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.CRITICAL);
            }
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        if (((BusinessServiceCheck)element).getPrototypeServiceId() != 0L) {
            return this.prototypeColor;
        }
        return null;
    }

    public void updateDciNames(Map<Long, DciInfo> names) {
        this.dciNameCache.putAll(names);
    }

    public void dispose() {
        this.objectLabelProvider.dispose();
        super.dispose();
    }
}

