/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.charts.widgets;

import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.datacollection.DataFormatter;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.modules.charts.api.DataSeries;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.charts.widgets.PlotArea;

public abstract class GenericComparisonChart
extends Canvas
implements PlotArea {
    protected Chart chart;
    protected boolean fontsCreated = false;

    public GenericComparisonChart(Chart parent) {
        super((Composite)parent, 0x20000000);
        this.setBackground(this.getDisplay().getSystemColor(25));
        this.chart = parent;
        this.addPaintListener((PaintListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected abstract void createFonts();

    protected abstract void disposeFonts();

    public void refresh() {
        this.redraw();
    }

    private void prepareGCAndRender(GC gc) {
        if (!this.fontsCreated) {
            this.createFonts();
            this.fontsCreated = true;
        }
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        this.render(gc);
    }

    protected abstract void render(GC var1);

    protected String getValueAsDisplayString(GraphItem dci, DataSeries data) {
        return new DataFormatter(dci.getDisplayFormat(), data.getDataType(), dci.getMeasurementUnit()).format(data.getCurrentValueAsString(), DateFormatFactory.getTimeFormatter());
    }
}

