/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.charts.widgets;

import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.netxms.client.datacollection.DataFormatter;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.modules.charts.api.DataSeries;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.charts.widgets.GenericComparisonChart;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.WidgetHelper;

public class PieChart
extends GenericComparisonChart {
    private static final int MARGIN_WIDTH = 5;
    private static final int MARGIN_HEIGHT = 5;
    private static final int MARK_TEXT_HEIGHT = 20;
    private static final int MARK_TEXT_WIDTH = 30;
    private static final int MARKS_OFFSET = 10;
    private Font[] scaleFonts = null;
    private Font[] valueFonts = null;

    public PieChart(Chart parent) {
        super(parent);
    }

    protected void createFonts() {
        int i;
        String fontName = this.chart.getConfiguration().getFontName();
        this.scaleFonts = new Font[16];
        for (i = 0; i < this.scaleFonts.length; ++i) {
            this.scaleFonts[i] = new Font((Device)this.getDisplay(), fontName, i + 6, 0);
        }
        this.valueFonts = new Font[16];
        for (i = 0; i < this.valueFonts.length; ++i) {
            this.valueFonts[i] = new Font((Device)this.getDisplay(), fontName, i * 2 + 6, 1);
        }
    }

    protected void disposeFonts() {
        int i;
        if (this.scaleFonts != null) {
            for (i = 0; i < this.scaleFonts.length; ++i) {
                this.scaleFonts[i].dispose();
            }
        }
        if (this.valueFonts != null) {
            for (i = 0; i < this.valueFonts.length; ++i) {
                this.valueFonts[i].dispose();
            }
        }
    }

    protected void render(GC gc) {
        Font markFont = WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.scaleFonts, (String)"100%", (int)30, (int)20);
        gc.setFont(markFont);
        Point markSize = gc.textExtent("100%");
        Point size = this.getSize();
        List items = this.chart.getItems();
        if (items.isEmpty() || size.x < 30 - markSize.x * 2 || size.y < 30 - markSize.y * 2) {
            return;
        }
        List series = this.chart.getDataSeries();
        if (series.isEmpty()) {
            return;
        }
        double total = 0.0;
        double[] values = new double[series.size()];
        for (int i = 0; i < series.size(); ++i) {
            values[i] = ((DataSeries)series.get(i)).getCurrentValue();
            total += values[i] < 0.0 ? 0.0 : values[i];
        }
        if (total == 0.0) {
            return;
        }
        double[] angularSize = new double[series.size()];
        for (int i = 0; i < values.length; ++i) {
            angularSize[i] = (values[i] < 0.0 ? 0.0 : values[i]) / total * 360.0;
        }
        if (this.chart.getConfiguration().isTranslucent()) {
            gc.setAlpha(127);
        }
        Color plotAreaColor = this.chart.getColorFromPreferences("Chart.Colors.PlotArea");
        Color scaleColor = this.chart.getColorFromPreferences("Chart.Colors.DialScale");
        gc.setForeground(scaleColor);
        int boxSize = Math.min(size.x - 10 - 20 - markSize.x * 2, size.y - 10 - 20 - markSize.y * 2);
        int x = (size.x - boxSize) / 2;
        int y = (size.y - boxSize) / 2;
        int cx = x + boxSize / 2 + 1;
        int cy = y + boxSize / 2 + 1;
        int startAngle = 0;
        for (int i = 0; i < values.length; ++i) {
            int color = ((GraphItem)items.get(i)).getColor();
            gc.setBackground(this.chart.getColorCache().create(color == -1 ? this.chart.getPaletteEntry(i).getRGBObject() : ColorConverter.rgbFromInt((int)color)));
            int sectorSize = i == values.length - 1 ? 360 - startAngle : (int)Math.round(angularSize[i]);
            gc.fillArc(x, y, boxSize, boxSize, startAngle, sectorSize);
            int pct = (int)(values[i] / total * 100.0);
            if (pct > 0) {
                int centerAngle = startAngle + sectorSize / 2;
                Point l1 = this.positionOnArc(cx, cy, boxSize / 2 + 10, centerAngle);
                Point l2 = this.positionOnArc(cx, cy, boxSize / 2, centerAngle);
                gc.drawLine(l1.x, l1.y, l2.x, l2.y);
                gc.setBackground(plotAreaColor);
                Point tc = this.positionOnArc(cx, cy, boxSize / 2 + 10 + markSize.y, centerAngle);
                String mark = Integer.toString(pct) + "%";
                Point ext = gc.textExtent(mark);
                gc.drawText(mark, tc.x - ext.x / 2, tc.y - ext.y / 2);
            }
            startAngle += sectorSize;
        }
        if (this.chart.getConfiguration().isDoughnutRendering()) {
            gc.setBackground(plotAreaColor);
            gc.setAlpha(255);
            int width = boxSize / 7;
            gc.fillArc(x + width, y + width, boxSize - width * 2, boxSize - width * 2, 0, 360);
        }
        if (this.chart.getConfiguration().isShowTotal()) {
            String v = new DataFormatter(((GraphItem)items.get(0)).getDisplayFormat(), ((DataSeries)series.get(0)).getDataType(), ((GraphItem)items.get(0)).getMeasurementUnit()).format(Double.toString(total), DateFormatFactory.getTimeFormatter());
            int innerBoxSize = boxSize - boxSize / 6;
            gc.setFont(WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.valueFonts, (String)"00000000", (int)innerBoxSize, (int)innerBoxSize));
            Point ext = gc.textExtent(v);
            if (ext.x <= innerBoxSize && ext.y <= innerBoxSize) {
                if (!this.chart.getConfiguration().isDoughnutRendering()) {
                    gc.setForeground(plotAreaColor);
                }
                gc.setAlpha(255);
                gc.drawText(v, cx - ext.x / 2, cy - ext.y / 2, 1);
            }
        }
    }

    private Point positionOnArc(int cx, int cy, int radius, int angle) {
        return new Point((int)((double)radius * Math.cos(Math.toRadians(angle)) + (double)cx), (int)((double)radius * -Math.sin(Math.toRadians(angle)) + (double)cy));
    }
}

